/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.BasicPixelProcessor;
import com.sixlegs.png.Destination;

final class GammaPixelProcessor
extends BasicPixelProcessor {
    private final short[] gammaTable;
    private final int shift;
    private final int samplesNoAlpha;
    private final boolean hasAlpha;
    private final boolean shiftAlpha;

    public GammaPixelProcessor(Destination destination, short[] sArray, int n) {
        super(destination, destination.getRaster().getNumBands());
        this.gammaTable = sArray;
        this.shift = n;
        this.hasAlpha = this.samples % 2 == 0;
        this.samplesNoAlpha = this.hasAlpha ? this.samples - 1 : this.samples;
        this.shiftAlpha = this.hasAlpha && n > 0;
    }

    @Override
    public boolean process(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = this.samples * n5;
        for (n6 = 0; n6 < this.samplesNoAlpha; ++n6) {
            for (int i = n6; i < n7; i += this.samples) {
                nArray[i] = 0xFFFF & this.gammaTable[nArray[i] >> this.shift];
            }
        }
        if (this.shiftAlpha) {
            for (n6 = this.samplesNoAlpha; n6 < n7; n6 += this.samples) {
                int n8 = n6;
                nArray[n8] = nArray[n8] >> this.shift;
            }
        }
        return super.process(nArray, n, n2, n3, n4, n5);
    }
}

