/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.PixelProcessor;
import com.sixlegs.png.PngException;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class Defilterer {
    private final InputStream in;
    private final int width;
    private final int bitDepth;
    private final int samples;
    private final PixelProcessor pp;
    private final int bpp;
    private final int[] row;
    private static int[][] bandOffsets = new int[][]{null, {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};

    public Defilterer(InputStream inputStream, int n, int n2, int n3, PixelProcessor pixelProcessor) {
        this.in = inputStream;
        this.bitDepth = n;
        this.samples = n2;
        this.width = n3;
        this.pp = pixelProcessor;
        this.bpp = Math.max(1, n * n2 >> 3);
        this.row = new int[n2 * n3];
    }

    public boolean defilter(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        if (n5 == 0 || n6 == 0) {
            return true;
        }
        int n7 = (this.bitDepth * this.samples * n5 + 7) / 8;
        boolean bl = this.bitDepth == 16;
        WritableRaster writableRaster = Defilterer.createInputRaster(this.bitDepth, this.samples, this.width);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        byte[] byArray = bl ? null : ((DataBufferByte)dataBuffer).getData();
        short[] sArray = bl ? ((DataBufferUShort)dataBuffer).getData() : null;
        int n8 = n7 + this.bpp;
        byte[] byArray2 = new byte[n8];
        byte[] byArray3 = new byte[n8];
        int n9 = 0;
        int n10 = n2;
        while (n9 < n6) {
            int n11 = this.in.read();
            if (n11 == -1) {
                throw new EOFException("Unexpected end of image data");
            }
            Defilterer.readFully(this.in, byArray3, this.bpp, n7);
            Defilterer.defilter(byArray3, byArray2, this.bpp, n11);
            if (bl) {
                int n12 = 0;
                for (int i = this.bpp; i < n8; i += 2) {
                    sArray[n12] = (short)(byArray3[i] << 8 | 0xFF & byArray3[i + 1]);
                    ++n12;
                }
            } else {
                System.arraycopy(byArray3, this.bpp, byArray, 0, n7);
            }
            writableRaster.getPixels(0, 0, n5, 1, this.row);
            if (!this.pp.process(this.row, n, n3, n4, n10, n5)) {
                return false;
            }
            byte[] byArray4 = byArray3;
            byArray3 = byArray2;
            byArray2 = byArray4;
            ++n9;
            n10 += n4;
        }
        return true;
    }

    private static void defilter(byte[] byArray, byte[] byArray2, int n, int n2) throws PngException {
        int n3 = byArray.length;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                int n4 = n;
                int n5 = 0;
                while (n4 < n3) {
                    byArray[n4] = (byte)(byArray[n4] + byArray[n5]);
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 2: {
                for (int i = n; i < n3; ++i) {
                    byArray[i] = (byte)(byArray[i] + byArray2[i]);
                }
                break;
            }
            case 3: {
                int n6 = n;
                int n7 = 0;
                while (n6 < n3) {
                    byArray[n6] = (byte)(byArray[n6] + ((0xFF & byArray[n7]) + (0xFF & byArray2[n6])) / 2);
                    ++n6;
                    ++n7;
                }
                break;
            }
            case 4: {
                int n8 = n;
                int n9 = 0;
                while (n8 < n3) {
                    int n10;
                    int n11;
                    byte by = byArray[n9];
                    int n12 = 0xFF & by;
                    byte by2 = byArray2[n8];
                    int n13 = 0xFF & by2;
                    byte by3 = byArray2[n9];
                    int n14 = 0xFF & by3;
                    int n15 = n12 + n13 - n14;
                    int n16 = n15 - n12;
                    if (n16 < 0) {
                        n16 = -n16;
                    }
                    if ((n11 = n15 - n13) < 0) {
                        n11 = -n11;
                    }
                    if ((n10 = n15 - n14) < 0) {
                        n10 = -n10;
                    }
                    int n17 = n16 <= n11 && n16 <= n10 ? n12 : (n11 <= n10 ? n13 : n14);
                    byArray[n8] = (byte)(byArray[n8] + n17);
                    ++n8;
                    ++n9;
                }
                break;
            }
            default: {
                throw new PngException("Unrecognized filter type " + n2, true);
            }
        }
    }

    private static WritableRaster createInputRaster(int n, int n2, int n3) {
        int n4 = (n * n2 * n3 + 7) / 8;
        Point point = new Point(0, 0);
        if (n < 8 && n2 == 1) {
            DataBufferByte dataBufferByte = new DataBufferByte(n4);
            return Raster.createPackedRaster(dataBufferByte, n3, 1, n, point);
        }
        if (n <= 8) {
            DataBufferByte dataBufferByte = new DataBufferByte(n4);
            return Raster.createInterleavedRaster(dataBufferByte, n3, 1, n4, n2, bandOffsets[n2], point);
        }
        DataBufferUShort dataBufferUShort = new DataBufferUShort(n4 / 2);
        return Raster.createInterleavedRaster(dataBufferUShort, n3, 1, n4 / 2, n2, bandOffsets[n2], point);
    }

    private static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 != -1) continue;
            throw new EOFException("Unexpected end of image data");
        }
    }
}

