/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

class ConvertIndexedDestination
extends Destination {
    private final Destination dst;
    private final IndexColorModel srcColorModel;
    private final int srcSamples;
    private final int dstSamples;
    private final int sampleDiff;
    private final int[] row;

    public ConvertIndexedDestination(Destination destination, int n, IndexColorModel indexColorModel, ComponentColorModel componentColorModel) {
        this.dst = destination;
        this.srcColorModel = indexColorModel;
        this.srcSamples = indexColorModel.getNumComponents();
        this.dstSamples = componentColorModel.getNumComponents();
        this.sampleDiff = this.srcSamples - this.dstSamples;
        this.row = new int[n * this.dstSamples + this.sampleDiff];
    }

    @Override
    public void setPixels(int n, int n2, int n3, int[] nArray) {
        int n4 = n3 - 1;
        int n5 = this.dstSamples * n4;
        while (n4 >= 0) {
            this.srcColorModel.getComponents(nArray[n4], this.row, n5);
            --n4;
            n5 -= this.dstSamples;
        }
        if (this.sampleDiff != 0) {
            System.arraycopy(this.row, this.sampleDiff, this.row, 0, this.dstSamples * n3);
        }
        this.dst.setPixels(n, n2, n3, this.row);
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray) {
        this.setPixels(n, n2, 1, nArray);
    }

    @Override
    public void getPixel(int n, int n2, int[] nArray) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public WritableRaster getRaster() {
        return this.dst.getRaster();
    }

    @Override
    public int getSourceWidth() {
        return this.dst.getSourceWidth();
    }

    @Override
    public void done() {
        this.dst.done();
    }
}

