/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.Lpc;
import com.jcraft.jorbis.Lsp;
import com.jcraft.jorbis.Util;

class Floor0
extends FuncFloor {
    float[] lsp = null;

    Floor0() {
    }

    static float fromdB(float f) {
        return (float)Math.exp((double)f * 0.11512925);
    }

    static void lpc_to_curve(float[] fArray, float[] fArray2, float f, LookFloor0 lookFloor0, String string, int n) {
        float[] fArray3 = new float[Math.max(lookFloor0.ln * 2, lookFloor0.m * 2 + 2)];
        if (f == 0.0f) {
            for (int i = 0; i < lookFloor0.n; ++i) {
                fArray[i] = 0.0f;
            }
            return;
        }
        lookFloor0.lpclook.lpc_to_curve(fArray3, fArray2, f);
        for (int i = 0; i < lookFloor0.n; ++i) {
            fArray[i] = fArray3[lookFloor0.linearmap[i]];
        }
    }

    static void lsp_to_lpc(float[] fArray, float[] fArray2, int n) {
        int n2;
        int n3;
        int n4 = n / 2;
        float[] fArray3 = new float[n4];
        float[] fArray4 = new float[n4];
        float[] fArray5 = new float[n4 + 1];
        float[] fArray6 = new float[n4 + 1];
        float[] fArray7 = new float[n4];
        float[] fArray8 = new float[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            fArray3[n3] = (float)(-2.0 * Math.cos(fArray[n3 * 2]));
            fArray4[n3] = (float)(-2.0 * Math.cos(fArray[n3 * 2 + 1]));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            fArray5[n2] = 0.0f;
            fArray6[n2] = 1.0f;
            fArray7[n2] = 0.0f;
            fArray8[n2] = 1.0f;
        }
        fArray6[n2] = 1.0f;
        fArray5[n2] = 1.0f;
        for (n3 = 1; n3 < n + 1; ++n3) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (n2 = 0; n2 < n4; ++n2) {
                float f3 = fArray3[n2] * fArray6[n2] + fArray5[n2];
                fArray5[n2] = fArray6[n2];
                fArray6[n2] = f2;
                f2 += f3;
                f3 = fArray4[n2] * fArray8[n2] + fArray7[n2];
                fArray7[n2] = fArray8[n2];
                fArray8[n2] = f;
                f += f3;
            }
            fArray2[n3 - 1] = (f2 + fArray6[n2] + f - fArray5[n2]) / 2.0f;
            fArray6[n2] = f2;
            fArray5[n2] = f;
        }
    }

    static float toBARK(float f) {
        return (float)(13.1 * Math.atan(7.4E-4 * (double)f) + 2.24 * Math.atan((double)(f * f) * 1.85E-8) + 1.0E-4 * (double)f);
    }

    @Override
    int forward(Block block, Object object, float[] fArray, float[] fArray2, Object object2) {
        return 0;
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    void free_state(Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int inverse(Block block, Object object, float[] fArray) {
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        int n = block.opb.read(infoFloor0.ampbits);
        if (n > 0) {
            int n2 = (1 << infoFloor0.ampbits) - 1;
            float f = (float)n / (float)n2 * (float)infoFloor0.ampdB;
            int n3 = block.opb.read(Util.ilog(infoFloor0.numbooks));
            if (n3 != -1 && n3 < infoFloor0.numbooks) {
                Floor0 floor0 = this;
                synchronized (floor0) {
                    int n4;
                    if (this.lsp == null || this.lsp.length < lookFloor0.m) {
                        this.lsp = new float[lookFloor0.m];
                    } else {
                        for (int i = 0; i < lookFloor0.m; ++i) {
                            this.lsp[i] = 0.0f;
                        }
                    }
                    CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n3]];
                    float f2 = 0.0f;
                    for (n4 = 0; n4 < lookFloor0.m; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                    for (n4 = 0; n4 < lookFloor0.m; n4 += codeBook.dim) {
                        if (codeBook.decodevs(this.lsp, n4, block.opb, 1, -1) != -1) continue;
                        for (int i = 0; i < lookFloor0.n; ++i) {
                            fArray[i] = 0.0f;
                        }
                        return 0;
                    }
                    n4 = 0;
                    while (n4 < lookFloor0.m) {
                        for (int i = 0; i < codeBook.dim; ++i) {
                            int n5 = n4++;
                            this.lsp[n5] = this.lsp[n5] + f2;
                        }
                        f2 = this.lsp[n4 - 1];
                    }
                    Lsp.lsp_to_curve(fArray, lookFloor0.linearmap, lookFloor0.n, lookFloor0.ln, this.lsp, lookFloor0.m, f, infoFloor0.ampdB);
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    Object inverse1(Block block, Object object, Object object2) {
        int n;
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        float[] fArray = null;
        if (object2 instanceof float[]) {
            fArray = (float[])object2;
        }
        if ((n = block.opb.read(infoFloor0.ampbits)) > 0) {
            int n2 = (1 << infoFloor0.ampbits) - 1;
            float f = (float)n / (float)n2 * (float)infoFloor0.ampdB;
            int n3 = block.opb.read(Util.ilog(infoFloor0.numbooks));
            if (n3 != -1 && n3 < infoFloor0.numbooks) {
                int n4;
                CodeBook codeBook = block.vd.fullbooks[infoFloor0.books[n3]];
                float f2 = 0.0f;
                if (fArray == null || fArray.length < lookFloor0.m + 1) {
                    fArray = new float[lookFloor0.m + 1];
                } else {
                    for (n4 = 0; n4 < fArray.length; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                }
                for (n4 = 0; n4 < lookFloor0.m; n4 += codeBook.dim) {
                    if (codeBook.decodev_set(fArray, n4, block.opb, codeBook.dim) != -1) continue;
                    return null;
                }
                n4 = 0;
                while (n4 < lookFloor0.m) {
                    for (int i = 0; i < codeBook.dim; ++i) {
                        int n5 = n4++;
                        fArray[n5] = fArray[n5] + f2;
                    }
                    f2 = fArray[n4 - 1];
                }
                fArray[lookFloor0.m] = f;
                return fArray;
            }
        }
        return null;
    }

    @Override
    int inverse2(Block block, Object object, Object object2, float[] fArray) {
        LookFloor0 lookFloor0 = (LookFloor0)object;
        InfoFloor0 infoFloor0 = lookFloor0.vi;
        if (object2 != null) {
            float[] fArray2 = (float[])object2;
            float f = fArray2[lookFloor0.m];
            Lsp.lsp_to_curve(fArray, lookFloor0.linearmap, lookFloor0.n, lookFloor0.ln, fArray2, lookFloor0.m, f, infoFloor0.ampdB);
            return 1;
        }
        for (int i = 0; i < lookFloor0.n; ++i) {
            fArray[i] = 0.0f;
        }
        return 0;
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        LookFloor0 lookFloor0 = new LookFloor0();
        lookFloor0.m = infoFloor0.order;
        lookFloor0.n = info.blocksizes[infoMode.blockflag] / 2;
        lookFloor0.ln = infoFloor0.barkmap;
        lookFloor0.vi = infoFloor0;
        lookFloor0.lpclook.init(lookFloor0.ln, lookFloor0.m);
        float f = (float)lookFloor0.ln / Floor0.toBARK((float)((double)infoFloor0.rate / 2.0));
        lookFloor0.linearmap = new int[lookFloor0.n];
        for (int i = 0; i < lookFloor0.n; ++i) {
            int n = (int)Math.floor(Floor0.toBARK((float)((double)infoFloor0.rate / 2.0 / (double)lookFloor0.n * (double)i)) * f);
            if (n >= lookFloor0.ln) {
                n = lookFloor0.ln;
            }
            lookFloor0.linearmap[i] = n;
        }
        return lookFloor0;
    }

    @Override
    void pack(Object object, Buffer buffer) {
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        buffer.write(infoFloor0.order, 8);
        buffer.write(infoFloor0.rate, 16);
        buffer.write(infoFloor0.barkmap, 16);
        buffer.write(infoFloor0.ampbits, 6);
        buffer.write(infoFloor0.ampdB, 8);
        buffer.write(infoFloor0.numbooks - 1, 4);
        for (int i = 0; i < infoFloor0.numbooks; ++i) {
            buffer.write(infoFloor0.books[i], 8);
        }
    }

    Object state(Object object) {
        EchstateFloor0 echstateFloor0 = new EchstateFloor0();
        InfoFloor0 infoFloor0 = (InfoFloor0)object;
        echstateFloor0.codewords = new int[infoFloor0.order];
        echstateFloor0.curve = new float[infoFloor0.barkmap];
        echstateFloor0.frameno = -1L;
        return echstateFloor0;
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        InfoFloor0 infoFloor0 = new InfoFloor0();
        infoFloor0.order = buffer.read(8);
        infoFloor0.rate = buffer.read(16);
        infoFloor0.barkmap = buffer.read(16);
        infoFloor0.ampbits = buffer.read(6);
        infoFloor0.ampdB = buffer.read(8);
        infoFloor0.numbooks = buffer.read(4) + 1;
        if (infoFloor0.order < 1 || infoFloor0.rate < 1 || infoFloor0.barkmap < 1 || infoFloor0.numbooks < 1) {
            return null;
        }
        for (int i = 0; i < infoFloor0.numbooks; ++i) {
            infoFloor0.books[i] = buffer.read(8);
            if (infoFloor0.books[i] >= 0 && infoFloor0.books[i] < info.books) continue;
            return null;
        }
        return infoFloor0;
    }

    class LookFloor0 {
        int[] linearmap;
        int ln;
        Lpc lpclook = new Lpc();
        int m;
        int n;
        InfoFloor0 vi;

        LookFloor0() {
        }
    }

    class InfoFloor0 {
        int ampbits;
        int ampdB;
        int barkmap;
        int[] books = new int[16];
        int numbooks;
        int order;
        int rate;

        InfoFloor0() {
        }
    }

    class EchstateFloor0 {
        long codes;
        int[] codewords;
        float[] curve;
        long frameno;

        EchstateFloor0() {
        }
    }
}

