/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.VorbisFile;
import zombie.debug.DebugLog;

class ChainingExample {
    ChainingExample() {
    }

    public static void main(String[] stringArray) {
        VorbisFile vorbisFile = null;
        try {
            vorbisFile = stringArray.length > 0 ? new VorbisFile(stringArray[0]) : new VorbisFile(System.in, null, -1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
        if (vorbisFile.seekable()) {
            DebugLog.log((String)("Input bitstream contained " + vorbisFile.streams() + " logical bitstream section(s)."));
            DebugLog.log((String)("Total bitstream playing time: " + vorbisFile.time_total(-1) + " seconds\n"));
        } else {
            DebugLog.log((String)"Standard input was not seekable.");
            DebugLog.log((String)"First logical bitstream information:\n");
        }
        for (int i = 0; i < vorbisFile.streams(); ++i) {
            Info info = vorbisFile.getInfo(i);
            DebugLog.log((String)("\tlogical bitstream section " + (i + 1) + " information:"));
            DebugLog.log((String)("\t\t" + info.rate + "Hz " + info.channels + " channels bitrate " + vorbisFile.bitrate(i) / 1000 + "kbps serial number=" + vorbisFile.serialnumber(i)));
            System.out.print("\t\tcompressed length: " + vorbisFile.raw_total(i) + " bytes ");
            DebugLog.log((String)(" play time: " + vorbisFile.time_total(i) + "s"));
            Comment comment = vorbisFile.getComment(i);
            DebugLog.log((Object)comment);
        }
    }
}

