/*
 * Decompiled with CFR 0.152.
 */
package com.evildevil.engines.bubble.texture;

import com.evildevil.engines.bubble.texture.DDPixelFormat;
import com.evildevil.engines.bubble.texture.DDSCaps2;
import com.evildevil.engines.bubble.texture.DDSurface;
import com.evildevil.engines.bubble.texture.TextureFormatException;

final class DDSurfaceDesc2
implements DDSurface {
    private final String DDS_IDENTIFIER = "DDS ";
    protected long identifier = 0L;
    private String identifierString = "";
    protected long size = 0L;
    protected long flags = 0L;
    protected long height = 0L;
    protected long width = 0L;
    protected long pitchOrLinearSize = 0L;
    protected long depth = 0L;
    protected long mipMapCount = 0L;
    protected long reserved = 0L;
    private DDPixelFormat pixelFormat = new DDPixelFormat();
    private DDSCaps2 caps2 = new DDSCaps2();
    protected int reserved2 = 0;

    public void setIdentifier(long l) throws TextureFormatException {
        this.identifier = l;
        this.createIdentifierString();
    }

    private void createIdentifierString() throws TextureFormatException {
        byte[] byArray = new byte[]{(byte)this.identifier, (byte)(this.identifier >> 8), (byte)(this.identifier >> 16), (byte)(this.identifier >> 24)};
        this.identifierString = new String(byArray);
        if (!this.identifierString.equalsIgnoreCase(this.DDS_IDENTIFIER)) {
            throw new TextureFormatException("The DDS Identifier is wrong. Have to be \"DDS \"!");
        }
    }

    public void setSize(long l) throws TextureFormatException {
        if (l != 124L) {
            throw new TextureFormatException("Wrong DDSurfaceDesc2 size. DDSurfaceDesc2 size must be 124!");
        }
        this.size = l;
    }

    public void setFlags(long l) throws TextureFormatException {
        this.flags = l;
        if ((l & 1L) != 1L || (l & 0x1000L) != 4096L || (l & 4L) != 4L || (l & 2L) != 2L) {
            throw new TextureFormatException("One or more required flag bits are set wrong\nflags have to include \"DDSD_CAPS, DDSD_PIXELFORMAT, DDSD_WIDTH, DDSD_HEIGHT\"");
        }
    }

    public void setHeight(long l) {
        this.height = Math.abs(l);
    }

    public void setWidth(long l) {
        this.width = l;
    }

    public void setPitchOrLinearSize(long l) {
        this.pitchOrLinearSize = l;
        this.pitchOrLinearSize = (this.width + 3L) / 4L * ((this.height + 3L) / 4L) * 16L;
        if (this.pitchOrLinearSize > 1000000L) {
            this.pitchOrLinearSize = (this.width + 3L) / 4L * ((this.height + 3L) / 4L) * 16L;
        }
    }

    public void setDepth(long l) {
        this.depth = l;
    }

    public void setMipMapCount(long l) {
        this.mipMapCount = l;
    }

    public void setDDPixelFormat(DDPixelFormat dDPixelFormat) throws NullPointerException {
        if (dDPixelFormat == null) {
            throw new NullPointerException("DDPixelFormat can't be null. DDSurfaceDesc2 needs a valid DDPixelFormat.");
        }
        this.pixelFormat = dDPixelFormat;
    }

    public DDPixelFormat getDDPixelformat() {
        return this.pixelFormat;
    }

    public void setDDSCaps2(DDSCaps2 dDSCaps2) throws NullPointerException {
        if (dDSCaps2 == null) {
            throw new NullPointerException("DDSCaps can't be null. DDSurfaceDesc2 needs a valid DDSCaps2.");
        }
        this.caps2 = dDSCaps2;
    }

    public DDSCaps2 getDDSCaps2() {
        return this.caps2;
    }
}

