/*
 * Decompiled with CFR 0.152.
 */
package com.evildevil.engines.bubble.texture;

import com.evildevil.engines.bubble.texture.DDPixelFormat;
import com.evildevil.engines.bubble.texture.DDSCaps2;
import com.evildevil.engines.bubble.texture.DDSurface;
import com.evildevil.engines.bubble.texture.DDSurfaceDesc2;
import com.evildevil.engines.bubble.texture.TextureFormatException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import zombie.core.textures.Texture;
import zombie.core.textures.TexturePackPage;
import zombie.debug.DebugLog;

public final class DDSLoader
implements DDSurface {
    private final String DDS_IDENTIFIER = "DDS ";
    private final int DDS_HEADER_SIZE = 128;
    private final int DDS_DESC2_RESERVED_1 = 44;
    private final int DDS_DESC2_RESERVED_2 = 4;
    private final int DDS_CAPS2_RESERVED = 8;
    private final int DEFAULT_DXT_BLOCKSIZE = 16;
    private final int DXT1_BLOCKSIZE = 8;
    private final DDSurfaceDesc2 ddsDesc2 = new DDSurfaceDesc2();
    private static ByteBuffer ddsHeader = null;
    private BufferedInputStream ddsFileChannel = null;
    static ByteBuffer imageData = null;
    static ByteBuffer imageData2 = null;
    public static int lastWid = 0;
    public static int lastHei = 0;

    public int loadDDSFile(String string) {
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (this.ddsFileChannel == null) {
                throw new NullPointerException("ddsFileChannel couldn't be null!");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (ddsHeader == null) {
            ddsHeader = ByteBuffer.allocate(128);
        }
        this.readFileHeader();
        int n = this.readFileData();
        return n;
    }

    public int loadDDSFile(BufferedInputStream bufferedInputStream) {
        this.ddsFileChannel = bufferedInputStream;
        if (this.ddsFileChannel == null) {
            throw new NullPointerException("ddsFileChannel couldn't be null!");
        }
        if (ddsHeader == null) {
            ddsHeader = ByteBuffer.allocate(128);
        }
        ddsHeader.rewind();
        this.readFileHeader();
        int n = this.readFileData();
        return n;
    }

    private void readFileHeader() {
        try {
            this.ddsFileChannel.read(ddsHeader.array());
            this.ddsDesc2.setIdentifier((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            this.ddsDesc2.setSize((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            this.ddsDesc2.setFlags((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            this.ddsDesc2.setHeight(TexturePackPage.readInt((ByteBuffer)ddsHeader));
            this.ddsDesc2.setWidth(TexturePackPage.readInt((ByteBuffer)ddsHeader));
            this.ddsDesc2.setPitchOrLinearSize((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            this.ddsDesc2.setDepth((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            this.ddsDesc2.setMipMapCount((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            ddsHeader.position(ddsHeader.position() + 44);
            DDPixelFormat dDPixelFormat = this.ddsDesc2.getDDPixelformat();
            dDPixelFormat.setSize((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setFlags((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setFourCC((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setRGBBitCount((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setRBitMask((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setGBitMask((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setBBitMask((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDPixelFormat.setRGBAlphaBitMask((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            DDSCaps2 dDSCaps2 = this.ddsDesc2.getDDSCaps2();
            dDSCaps2.setCaps1((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            dDSCaps2.setCaps2((long)TexturePackPage.readInt((ByteBuffer)ddsHeader) & 0xFFFFFFFFL);
            ddsHeader.position(ddsHeader.position() + 8);
            ddsHeader.position(ddsHeader.position() + 4);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
        }
        catch (TextureFormatException textureFormatException) {
            textureFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int readFileData() {
        int n;
        DDPixelFormat dDPixelFormat = this.ddsDesc2.getDDPixelformat();
        int n2 = 0;
        int n3 = 0;
        if (dDPixelFormat.isCompressed && dDPixelFormat.getFourCCString().equalsIgnoreCase("DXT1")) {
            n2 = this.calculateSize(8);
            n3 = 33777;
        } else {
            n2 = this.calculateSize(16);
            if (dDPixelFormat.getFourCCString().equalsIgnoreCase("DXT3")) {
                n3 = 33778;
            } else if (dDPixelFormat.getFourCCString().equals("DXT5")) {
                n3 = 33779;
            }
        }
        if (imageData == null) {
            imageData = ByteBuffer.allocate(0x400000);
        }
        imageData.rewind();
        try {
            this.ddsFileChannel.read(imageData.array(), 0, (int)this.ddsDesc2.pitchOrLinearSize);
            imageData.flip();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (imageData2 == null) {
            imageData2 = ByteBuffer.allocateDirect(0x400000);
        }
        imageData2.clear();
        imageData2.put(imageData.array(), 0, (int)this.ddsDesc2.pitchOrLinearSize);
        imageData2.flip();
        lastWid = (int)this.ddsDesc2.width;
        lastHei = (int)this.ddsDesc2.height;
        Texture.lastTextureID = n = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)Texture.lastTextureID);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL13.glCompressedTexImage2D((int)3553, (int)0, (int)n3, (int)((int)this.ddsDesc2.width), (int)((int)this.ddsDesc2.height), (int)0, (ByteBuffer)imageData2);
        return n;
    }

    private int calculateSize(int n) {
        double d = Math.ceil(this.ddsDesc2.width / 4L) * Math.ceil(this.ddsDesc2.height / 4L) * (double)n;
        return (int)d;
    }

    public void debugInfo() {
        DDPixelFormat dDPixelFormat = this.ddsDesc2.getDDPixelformat();
        DDSCaps2 dDSCaps2 = this.ddsDesc2.getDDSCaps2();
        DebugLog.log((String)"\nDDSURFACEDESC2:");
        DebugLog.log((String)"----------------------------------------");
        DebugLog.log((String)("SIZE: " + this.ddsDesc2.size));
        DebugLog.log((String)("FLAGS: " + this.ddsDesc2.flags));
        DebugLog.log((String)("HEIGHT: " + this.ddsDesc2.height));
        DebugLog.log((String)("WIDTH: " + this.ddsDesc2.width));
        DebugLog.log((String)("PITCH_OR_LINEAR_SIZE: " + this.ddsDesc2.pitchOrLinearSize));
        DebugLog.log((String)("DEPTH: " + this.ddsDesc2.depth));
        DebugLog.log((String)("MIP_MAP_COUNT: " + this.ddsDesc2.mipMapCount));
        DebugLog.log((String)"\nDDPIXELFORMAT of DDSURFACEDESC2:");
        DebugLog.log((String)"----------------------------------------");
        DebugLog.log((String)("SIZE :" + dDPixelFormat.size));
        DebugLog.log((String)("FLAGS: " + dDPixelFormat.flags));
        DebugLog.log((String)("FOUR_CC: " + dDPixelFormat.getFourCCString()));
        DebugLog.log((String)("RGB_BIT_COUNT: " + dDPixelFormat.rgbBitCount));
        DebugLog.log((String)("R_BIT_MASK: " + dDPixelFormat.rBitMask));
        DebugLog.log((String)("G_BIT_MASK: " + dDPixelFormat.gBitMask));
        DebugLog.log((String)("B_BIT_MASK: " + dDPixelFormat.bBitMask));
        DebugLog.log((String)("RGB_ALPHA_BIT_MASK: " + dDPixelFormat.rgbAlphaBitMask));
        DebugLog.log((String)"\nDDSCAPS of DDSURFACEDESC2");
        DebugLog.log((String)"----------------------------------------");
        DebugLog.log((String)("CAPS1: " + dDSCaps2.caps1));
        DebugLog.log((String)("CAPS2: " + dDSCaps2.caps2));
    }
}

