/*
 * Decompiled with CFR 0.152.
 */
package com.evildevil.engines.bubble.texture;

import com.evildevil.engines.bubble.texture.DDSurface;
import com.evildevil.engines.bubble.texture.TextureFormatException;

final class DDPixelFormat
implements DDSurface {
    protected long size = 0L;
    protected long flags = 0L;
    protected long fourCC = 0L;
    private String fourCCString = "";
    protected long rgbBitCount = 0L;
    protected long rBitMask = 0L;
    protected long gBitMask = 0L;
    protected long bBitMask = 0L;
    protected long rgbAlphaBitMask = 0L;
    protected boolean isCompressed = true;

    public void setSize(long l) throws TextureFormatException {
        if (l != 32L) {
            throw new TextureFormatException("Wrong DDPixelFormat size. DDPixelFormat size must be 32!");
        }
        this.size = l;
    }

    public void setFlags(long l) {
        this.flags = l;
        if ((l & 0x40L) == 64L) {
            this.isCompressed = false;
        } else if ((l & 4L) == 4L) {
            this.isCompressed = true;
        }
    }

    public void setFourCC(long l) {
        this.fourCC = l;
        if (this.isCompressed) {
            this.createFourCCString();
        }
    }

    private void createFourCCString() {
        byte[] byArray = new byte[]{(byte)this.fourCC, (byte)(this.fourCC >> 8), (byte)(this.fourCC >> 16), (byte)(this.fourCC >> 24)};
        this.fourCCString = new String(byArray);
    }

    public String getFourCCString() {
        return this.fourCCString;
    }

    public void setRGBBitCount(long l) {
        this.rgbAlphaBitMask = l;
    }

    public void setRBitMask(long l) {
        this.rBitMask = l;
    }

    public void setGBitMask(long l) {
        this.gBitMask = l;
    }

    public void setBBitMask(long l) {
        this.bBitMask = l;
    }

    public void setRGBAlphaBitMask(long l) {
        this.rgbAlphaBitMask = l;
    }
}

