/*
 * Decompiled with CFR 0.152.
 */
package astar.tests;

import astar.ASearchNode;
import astar.ISearchNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class SearchNodeCity
extends ASearchNode {
    private String name;
    private SearchNodeCity parent;
    private SearchNodeCity goal;
    private HashMap<String, HashMap<String, Integer>> adjacencyMatrix = new HashMap();

    public SearchNodeCity(String string) {
        this.name = string;
        this.fillAdjacencyMatrix();
    }

    private void fillAdjacencyMatrix() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Kaiserslautern", 70);
        hashMap.put("Karlsruhe", 145);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap2.put("Frankfurt", 103);
        hashMap2.put("Ludwigshafen", 53);
        HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
        hashMap3.put("Heilbronn", 84);
        HashMap<String, Integer> hashMap4 = new HashMap<String, Integer>();
        hashMap4.put("W\u00c3\u00bcrzburg", 116);
        HashMap<String, Integer> hashMap5 = new HashMap<String, Integer>();
        hashMap5.put("W\u00c3\u00bcrzburg", 183);
        HashMap<String, Integer> hashMap6 = new HashMap<String, Integer>();
        hashMap6.put("W\u00c3\u00bcrzburg", 102);
        this.adjacencyMatrix.put("Saarbr\u00c3\u00bccken", hashMap);
        this.adjacencyMatrix.put("Kaiserslautern", hashMap2);
        this.adjacencyMatrix.put("Frankfurt", hashMap4);
        this.adjacencyMatrix.put("Karlsruhe", hashMap3);
        this.adjacencyMatrix.put("Ludwigshafen", hashMap5);
        this.adjacencyMatrix.put("Heilbronn", hashMap6);
    }

    @Override
    public double h() {
        switch (this.name) {
            case "Saarbr\u00c3\u00bccken": {
                return 222.0;
            }
            case "Kaiserslautern": {
                return 158.0;
            }
            case "Karlsruhe": {
                return 140.0;
            }
            case "Frankfurt": {
                return 96.0;
            }
            case "Ludwigshafen": {
                return 108.0;
            }
            case "Heilbronn": {
                return 87.0;
            }
            case "W\u00c3\u00bcrzburg": {
                return 0.0;
            }
        }
        return 0.0;
    }

    @Override
    public double c(ISearchNode iSearchNode) {
        return this.adjacencyMatrix.get(this.name).get(this.castToSearchNodeCity(iSearchNode).getName()).intValue();
    }

    @Override
    public void getSuccessors(ArrayList<ISearchNode> arrayList) {
        Set<String> set = this.adjacencyMatrix.get(this.name).keySet();
        for (String string : set) {
            arrayList.add(new SearchNodeCity(string));
        }
    }

    public ArrayList<ISearchNode> getSuccessors() {
        ArrayList<ISearchNode> arrayList = new ArrayList<ISearchNode>();
        Set<String> set = this.adjacencyMatrix.get(this.name).keySet();
        for (String string : set) {
            arrayList.add(new SearchNodeCity(string));
        }
        return arrayList;
    }

    @Override
    public SearchNodeCity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ISearchNode iSearchNode) {
        this.parent = this.castToSearchNodeCity(iSearchNode);
    }

    @Override
    public Integer keyCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SearchNodeCity) {
            SearchNodeCity searchNodeCity = (SearchNodeCity)object;
            return this.name == searchNodeCity.getName();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    private SearchNodeCity castToSearchNodeCity(ISearchNode iSearchNode) {
        return (SearchNodeCity)iSearchNode;
    }

    public String toString() {
        return this.name + ",f:" + this.f();
    }
}

