/*
 * Decompiled with CFR 0.152.
 */
package astar.tests;

import astar.ASearchNode;
import astar.ISearchNode;
import astar.tests.GoalNode2D;
import java.util.ArrayList;

public class SearchNode2D
extends ASearchNode {
    private int x;
    private int y;
    private SearchNode2D parent;
    private GoalNode2D goal;

    public SearchNode2D(int n, int n2, SearchNode2D searchNode2D, GoalNode2D goalNode2D) {
        this.x = n;
        this.y = n2;
        this.parent = searchNode2D;
        this.goal = goalNode2D;
    }

    @Override
    public SearchNode2D getParent() {
        return this.parent;
    }

    public ArrayList<ISearchNode> getSuccessors() {
        ArrayList<ISearchNode> arrayList = new ArrayList<ISearchNode>();
        arrayList.add(new SearchNode2D(this.x - 1, this.y, this, this.goal));
        arrayList.add(new SearchNode2D(this.x + 1, this.y, this, this.goal));
        arrayList.add(new SearchNode2D(this.x, this.y + 1, this, this.goal));
        arrayList.add(new SearchNode2D(this.x, this.y - 1, this, this.goal));
        return arrayList;
    }

    @Override
    public double h() {
        return this.dist(this.goal.getX(), this.goal.getY());
    }

    @Override
    public double c(ISearchNode iSearchNode) {
        SearchNode2D searchNode2D = this.castToSearchNode2D(iSearchNode);
        return 1.0;
    }

    @Override
    public void getSuccessors(ArrayList<ISearchNode> arrayList) {
        arrayList.add(new SearchNode2D(this.x - 1, this.y, this, this.goal));
        arrayList.add(new SearchNode2D(this.x + 1, this.y, this, this.goal));
        arrayList.add(new SearchNode2D(this.x, this.y + 1, this, this.goal));
        arrayList.add(new SearchNode2D(this.x, this.y - 1, this, this.goal));
    }

    @Override
    public void setParent(ISearchNode iSearchNode) {
        this.parent = this.castToSearchNode2D(iSearchNode);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SearchNode2D) {
            SearchNode2D searchNode2D = (SearchNode2D)object;
            return this.x == searchNode2D.getX() && this.y == searchNode2D.getY();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 41 * (41 + this.x + this.y);
    }

    public double dist(int n, int n2) {
        return Math.sqrt(Math.pow(this.x - n, 2.0) + Math.pow(this.y - n2, 2.0));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        return "(" + Integer.toString(this.x) + ";" + Integer.toString(this.y) + ";h:" + Double.toString(this.h()) + ";g:" + Double.toString(this.g()) + ")";
    }

    private SearchNode2D castToSearchNode2D(ISearchNode iSearchNode) {
        return (SearchNode2D)iSearchNode;
    }

    @Override
    public Integer keyCode() {
        return null;
    }
}

