/*
 * Decompiled with CFR 0.152.
 */
package astar.tests;

import astar.AStar;
import astar.ISearchNode;
import astar.tests.GoalNode2D;
import astar.tests.GoalNodeCity;
import astar.tests.SearchNode2D;
import astar.tests.SearchNodeCity;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class AStarTest {
    @Test
    public void SearchNodeTest2D() {
        GoalNode2D goalNode2D = new GoalNode2D(3, 3);
        SearchNode2D searchNode2D = new SearchNode2D(1, 1, null, goalNode2D);
        ArrayList<ISearchNode> arrayList = new AStar().shortestPath(searchNode2D, goalNode2D);
        Assert.assertEquals((long)arrayList.size(), (long)5L);
    }

    @Test
    public void SearchNodeCityTest() {
        SearchNodeCity searchNodeCity = new SearchNodeCity("Saarbr\u00c3\u00bccken");
        ArrayList<ISearchNode> arrayList = new AStar().shortestPath(searchNodeCity, new GoalNodeCity("W\u00c3\u00bcrzburg"));
        double d = 1.0E-5;
        Assert.assertEquals((double)arrayList.get(0).f(), (double)222.0, (double)d);
        Assert.assertEquals((double)arrayList.get(1).f(), (double)228.0, (double)d);
        Assert.assertEquals((double)arrayList.get(2).f(), (double)269.0, (double)d);
        Assert.assertEquals((double)arrayList.get(3).f(), (double)289.0, (double)d);
        Assert.assertEquals((Object)arrayList.toString(), (Object)"[Saarbr\u00c3\u00bccken,f:222.0, Kaiserslautern,f:228.0, Frankfurt,f:269.0, W\u00c3\u00bcrzburg,f:289.0]");
    }
}

