/*
 * Decompiled with CFR 0.152.
 */
package astar.datastructures;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class HashPriorityQueue<K, V> {
    HashMap<K, V> hashMap = new HashMap();
    TreeMap<V, K> treeMap;

    public HashPriorityQueue(Comparator<V> comparator) {
        this.treeMap = new TreeMap(comparator);
    }

    public int size() {
        return this.treeMap.size();
    }

    public boolean isEmpty() {
        return this.treeMap.isEmpty();
    }

    public boolean contains(K k) {
        return this.hashMap.containsKey(k);
    }

    public V get(K k) {
        return this.hashMap.get(k);
    }

    public boolean add(K k, V v) {
        this.hashMap.put(k, v);
        this.treeMap.put(v, k);
        return true;
    }

    public boolean remove(K k, V v) {
        if (v == null) {
            v = this.hashMap.get(k);
        }
        this.hashMap.remove(k);
        this.treeMap.remove(v);
        return true;
    }

    public V poll() {
        Map.Entry<V, K> entry = this.treeMap.pollFirstEntry();
        return entry.getKey();
    }

    public void clear() {
        this.hashMap.clear();
        this.treeMap.clear();
    }

    public HashMap<K, V> getHashMap() {
        return this.hashMap;
    }

    public TreeMap<V, K> getTreeMap() {
        return this.treeMap;
    }
}

