/*
 * Decompiled with CFR 0.152.
 */
package astar.datastructures;

import astar.ISearchNode;
import astar.datastructures.IClosedSet;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Comparator;

public class ClosedSetHash
implements IClosedSet {
    private TIntObjectHashMap<ISearchNode> hashMap = new TIntObjectHashMap();
    private Comparator<ISearchNode> comp;
    private static final MinNodeProc minNodeProc = new MinNodeProc();

    public ClosedSetHash(Comparator<ISearchNode> comparator) {
        this.comp = comparator;
    }

    @Override
    public boolean contains(ISearchNode iSearchNode) {
        return this.hashMap.containsKey(iSearchNode.keyCode().intValue());
    }

    @Override
    public void add(ISearchNode iSearchNode) {
        this.hashMap.put(iSearchNode.keyCode().intValue(), (Object)iSearchNode);
    }

    @Override
    public ISearchNode min() {
        ClosedSetHash.minNodeProc.comp = this.comp;
        ClosedSetHash.minNodeProc.candidate = null;
        this.hashMap.forEachValue((TObjectProcedure)minNodeProc);
        return ClosedSetHash.minNodeProc.candidate;
    }

    @Override
    public void clear() {
        this.hashMap.clear();
    }

    private static final class MinNodeProc
    implements TObjectProcedure<ISearchNode> {
        Comparator<ISearchNode> comp;
        ISearchNode candidate;

        private MinNodeProc() {
        }

        public boolean execute(ISearchNode iSearchNode) {
            if (this.candidate == null) {
                this.candidate = iSearchNode;
                return true;
            }
            if (this.comp.compare(iSearchNode, this.candidate) < 0) {
                this.candidate = iSearchNode;
            }
            return true;
        }
    }
}

