/*
 * Decompiled with CFR 0.152.
 */
package astar;

import astar.IGoalNode;
import astar.ISearchNode;
import astar.datastructures.ClosedSet;
import astar.datastructures.ClosedSetHash;
import astar.datastructures.IClosedSet;
import astar.datastructures.IOpenSet;
import astar.datastructures.OpenSet;
import java.util.ArrayList;
import java.util.Comparator;

public class AStar {
    private int verbose = 0;
    private int maxSteps = -1;
    private int numSearchSteps;
    public ISearchNode bestNodeAfterSearch;
    private ArrayList<ISearchNode> successorNodes = new ArrayList();
    private final IOpenSet openSet = new OpenSet(new SearchNodeComparator());
    private final IClosedSet closedSetHash = new ClosedSetHash(new SearchNodeComparator());
    private final IClosedSet closedSetNoHash = new ClosedSet(new SearchNodeComparator());

    public ArrayList<ISearchNode> shortestPath(ISearchNode iSearchNode, IGoalNode iGoalNode) {
        ISearchNode iSearchNode2 = this.search(iSearchNode, iGoalNode);
        if (iSearchNode2 == null) {
            return null;
        }
        return AStar.path(iSearchNode2);
    }

    public ISearchNode search(ISearchNode iSearchNode, IGoalNode iGoalNode) {
        boolean bl = iSearchNode.keyCode() != null;
        iSearchNode.setDepth(0);
        this.openSet.clear();
        this.openSet.add(iSearchNode);
        IClosedSet iClosedSet = bl ? this.closedSetHash : this.closedSetNoHash;
        iClosedSet.clear();
        this.numSearchSteps = 0;
        while (this.openSet.size() > 0 && (this.maxSteps < 0 || this.numSearchSteps < this.maxSteps)) {
            ISearchNode iSearchNode2 = this.openSet.poll();
            if (iGoalNode.inGoal(iSearchNode2)) {
                this.bestNodeAfterSearch = iSearchNode2;
                return iSearchNode2;
            }
            this.successorNodes.clear();
            iSearchNode2.getSuccessors(this.successorNodes);
            for (int i = 0; i < this.successorNodes.size(); ++i) {
                boolean bl2;
                ISearchNode iSearchNode3 = this.successorNodes.get(i);
                if (iClosedSet.contains(iSearchNode3)) continue;
                ISearchNode iSearchNode4 = this.openSet.getNode(iSearchNode3);
                if (iSearchNode4 != null) {
                    iSearchNode3 = iSearchNode4;
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                double d = iSearchNode2.g() + iSearchNode2.c(iSearchNode3);
                if (bl2 && d >= iSearchNode3.g()) continue;
                iSearchNode3.setParent(iSearchNode2);
                iSearchNode3.setDepth(iSearchNode2.getDepth() + 1);
                if (bl2) {
                    this.openSet.remove(iSearchNode3);
                    iSearchNode3.setG(d);
                    this.openSet.add(iSearchNode3);
                    continue;
                }
                iSearchNode3.setG(d);
                this.openSet.add(iSearchNode3);
            }
            iClosedSet.add(iSearchNode2);
            ++this.numSearchSteps;
        }
        this.bestNodeAfterSearch = iClosedSet.min();
        return null;
    }

    public static ArrayList<ISearchNode> path(ISearchNode iSearchNode) {
        ArrayList<ISearchNode> arrayList = new ArrayList<ISearchNode>();
        arrayList.add(iSearchNode);
        ISearchNode iSearchNode2 = iSearchNode;
        while (iSearchNode2.getParent() != null) {
            ISearchNode iSearchNode3 = iSearchNode2.getParent();
            arrayList.add(0, iSearchNode3);
            iSearchNode2 = iSearchNode3;
        }
        return arrayList;
    }

    public int numSearchSteps() {
        return this.numSearchSteps;
    }

    public ISearchNode bestNodeAfterSearch() {
        return this.bestNodeAfterSearch;
    }

    public void setMaxSteps(int n) {
        this.maxSteps = n;
    }

    static class SearchNodeComparator
    implements Comparator<ISearchNode> {
        SearchNodeComparator() {
        }

        @Override
        public int compare(ISearchNode iSearchNode, ISearchNode iSearchNode2) {
            return Double.compare(iSearchNode.f(), iSearchNode2.f());
        }
    }
}

