/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server.role;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.permissions.Permissions;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplPermissions;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.role.RoleChangeColorListener;
import de.btobastian.javacord.listener.role.RoleChangeHoistListener;
import de.btobastian.javacord.listener.role.RoleChangeNameListener;
import de.btobastian.javacord.listener.role.RoleChangePermissionsListener;
import de.btobastian.javacord.listener.role.RoleChangePositionListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.awt.Color;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildRoleUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildRoleUpdateHandler.class);

    public GuildRoleUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_ROLE_UPDATE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(JSONObject packet) {
        String guildId = packet.getString("guild_id");
        JSONObject roleJson = packet.getJSONObject("role");
        Server server = this.api.getServerById(guildId);
        final ImplRole role = (ImplRole)server.getRoleById(roleJson.getString("id"));
        String name = roleJson.getString("name");
        if (!role.getName().equals(name)) {
            final String oldName = role.getName();
            role.setName(name);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<RoleChangeNameListener> listeners;
                    List<RoleChangeNameListener> list = listeners = GuildRoleUpdateHandler.this.api.getListeners(RoleChangeNameListener.class);
                    synchronized (list) {
                        for (RoleChangeNameListener listener : listeners) {
                            try {
                                listener.onRoleChangeName(GuildRoleUpdateHandler.this.api, role, oldName);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in RoleChangeNameListener!", t);
                            }
                        }
                    }
                }
            });
        }
        ImplPermissions permissions = new ImplPermissions(roleJson.getInt("permissions"));
        if (!role.getPermissions().equals(permissions)) {
            final Permissions oldPermissions = role.getPermissions();
            role.setPermissions(permissions);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<RoleChangePermissionsListener> listeners;
                    List<RoleChangePermissionsListener> list = listeners = GuildRoleUpdateHandler.this.api.getListeners(RoleChangePermissionsListener.class);
                    synchronized (list) {
                        for (RoleChangePermissionsListener listener : listeners) {
                            try {
                                listener.onRoleChangePermissions(GuildRoleUpdateHandler.this.api, role, oldPermissions);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in RoleChangePermissionsListener!", t);
                            }
                        }
                    }
                }
            });
        }
        Color color = new Color(roleJson.getInt("color"));
        if (role.getColor().getRGB() != color.getRGB()) {
            final Color oldColor = role.getColor();
            role.setColor(color);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<RoleChangeColorListener> listeners;
                    List<RoleChangeColorListener> list = listeners = GuildRoleUpdateHandler.this.api.getListeners(RoleChangeColorListener.class);
                    synchronized (list) {
                        for (RoleChangeColorListener listener : listeners) {
                            try {
                                listener.onRoleChangeColor(GuildRoleUpdateHandler.this.api, role, oldColor);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in RoleChangeColorListener!", t);
                            }
                        }
                    }
                }
            });
        }
        if (role.getHoist() != roleJson.getBoolean("hoist")) {
            role.setHoist(!role.getHoist());
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<RoleChangeHoistListener> listeners;
                    List<RoleChangeHoistListener> list = listeners = GuildRoleUpdateHandler.this.api.getListeners(RoleChangeHoistListener.class);
                    synchronized (list) {
                        for (RoleChangeHoistListener listener : listeners) {
                            try {
                                listener.onRoleChangeHoist(GuildRoleUpdateHandler.this.api, role, !role.getHoist());
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in RoleChangeHoistListener!", t);
                            }
                        }
                    }
                }
            });
        }
        Class<Role> clazz = Role.class;
        synchronized (Role.class) {
            int position = roleJson.getInt("position");
            if (role.getPosition() != position) {
                final int oldPosition = role.getPosition();
                role.setPosition(position);
                this.listenerExecutorService.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<RoleChangePositionListener> listeners;
                        List<RoleChangePositionListener> list = listeners = GuildRoleUpdateHandler.this.api.getListeners(RoleChangePositionListener.class);
                        synchronized (list) {
                            for (RoleChangePositionListener listener : listeners) {
                                try {
                                    listener.onRoleChangePosition(GuildRoleUpdateHandler.this.api, role, oldPosition);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in RoleChangePositionListener!", t);
                                }
                            }
                        }
                    }
                });
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }
}

