/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server.role;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.listener.role.RoleDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildRoleDeleteHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildRoleDeleteHandler.class);

    public GuildRoleDeleteHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_ROLE_DELETE");
    }

    @Override
    public void handle(JSONObject packet) {
        String guildId = packet.getString("guild_id");
        String roleId = packet.getString("role_id");
        Server server = this.api.getServerById(guildId);
        final Role role = server.getRoleById(roleId);
        if (role == null) {
            return;
        }
        ((ImplServer)server).removeRole(role);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<RoleDeleteListener> listeners;
                List<RoleDeleteListener> list = listeners = GuildRoleDeleteHandler.this.api.getListeners(RoleDeleteListener.class);
                synchronized (list) {
                    for (RoleDeleteListener listener : listeners) {
                        try {
                            listener.onRoleDelete(GuildRoleDeleteHandler.this.api, role);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in RoleDeleteListener!", t);
                        }
                    }
                }
            }
        });
    }
}

