/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.listener.server.ServerMemberAddListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildMemberAddHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildMemberAddHandler.class);

    public GuildMemberAddHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_MEMBER_ADD");
    }

    @Override
    public void handle(JSONObject packet) {
        final Server server = this.api.getServerById(packet.getString("guild_id"));
        final User user = this.api.getOrCreateUser(packet.getJSONObject("user"));
        if (server != null) {
            ((ImplServer)server).addMember(user);
            ((ImplServer)server).incrementMemberCount();
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerMemberAddListener> listeners;
                    List<ServerMemberAddListener> list = listeners = GuildMemberAddHandler.this.api.getListeners(ServerMemberAddListener.class);
                    synchronized (list) {
                        for (ServerMemberAddListener listener : listeners) {
                            try {
                                listener.onServerMemberAdd(GuildMemberAddHandler.this.api, user, server);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerMemberAddListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

