/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.listener.server.ServerJoinListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildCreateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildCreateHandler.class);

    public GuildCreateHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_CREATE");
    }

    @Override
    public void handle(JSONObject packet) {
        if (packet.has("unavailable") && packet.getBoolean("unavailable")) {
            return;
        }
        String id = packet.getString("id");
        if (this.api.getUnavailableServers().contains(id)) {
            this.api.getUnavailableServers().remove(id);
            new ImplServer(packet, this.api);
            return;
        }
        if (this.api.getServerById(id) != null) {
            return;
        }
        final ImplServer server = new ImplServer(packet, this.api);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ServerJoinListener> listeners;
                List<ServerJoinListener> list = listeners = GuildCreateHandler.this.api.getListeners(ServerJoinListener.class);
                synchronized (list) {
                    for (ServerJoinListener listener : listeners) {
                        try {
                            listener.onServerJoin(GuildCreateHandler.this.api, server);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in ServerJoinListener!", t);
                        }
                    }
                }
            }
        });
        this.api.getThreadPool().getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                GuildCreateHandler.this.api.getInternalServerJoinListener().onServerJoin(GuildCreateHandler.this.api, server);
            }
        });
    }
}

