/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.server;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.listener.server.ServerMemberUnbanListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class GuildBanRemoveHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(GuildBanRemoveHandler.class);

    public GuildBanRemoveHandler(ImplDiscordAPI api) {
        super(api, true, "GUILD_BAN_REMOVE");
    }

    @Override
    public void handle(JSONObject packet) {
        final Server server = this.api.getServerById(packet.getString("guild_id"));
        final User user = this.api.getOrCreateUser(packet.getJSONObject("user"));
        if (server != null) {
            ((ImplServer)server).removeMember(user);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ServerMemberUnbanListener> listeners;
                    List<ServerMemberUnbanListener> list = listeners = GuildBanRemoveHandler.this.api.getListeners(ServerMemberUnbanListener.class);
                    synchronized (list) {
                        for (ServerMemberUnbanListener listener : listeners) {
                            try {
                                listener.onServerMemberUnban(GuildBanRemoveHandler.this.api, user.getId(), server);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ServerMemberUnbanListener!", t);
                            }
                        }
                    }
                }
            });
        }
    }
}

