/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.message;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.Reaction;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.listener.message.ReactionRemoveAllListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class MessageReactionRemoveAllHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(MessageReactionRemoveAllHandler.class);

    public MessageReactionRemoveAllHandler(ImplDiscordAPI api) {
        super(api, true, "MESSAGE_REACTION_REMOVE_ALL");
    }

    @Override
    public void handle(JSONObject packet) {
        String messageId = packet.getString("message_id");
        final Message message = this.api.getMessageById(messageId);
        if (message == null) {
            return;
        }
        final List<Reaction> reactions = message.getReactions();
        ((ImplMessage)message).removeAllReactionsFromCache();
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ReactionRemoveAllListener> listeners;
                List<ReactionRemoveAllListener> list = listeners = MessageReactionRemoveAllHandler.this.api.getListeners(ReactionRemoveAllListener.class);
                synchronized (list) {
                    for (ReactionRemoveAllListener listener : listeners) {
                        try {
                            listener.onReactionRemoveAll(MessageReactionRemoveAllHandler.this.api, message, reactions);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in ReactionRemoveAllListener!", t);
                        }
                    }
                }
            }
        });
    }
}

