/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.channel;

import de.btobastian.javacord.DiscordAPI;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.impl.ImplChannel;
import de.btobastian.javacord.entities.impl.ImplVoiceChannel;
import de.btobastian.javacord.entities.permissions.Permissions;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplPermissions;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.channel.ChannelChangeNameListener;
import de.btobastian.javacord.listener.channel.ChannelChangePositionListener;
import de.btobastian.javacord.listener.channel.ChannelChangeTopicListener;
import de.btobastian.javacord.listener.role.RoleChangeOverwrittenPermissionsListener;
import de.btobastian.javacord.listener.user.UserChangeOverwrittenPermissionsListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelChangeNameListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelChangePositionListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ChannelUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ChannelUpdateHandler.class);

    public ChannelUpdateHandler(ImplDiscordAPI api) {
        super(api, true, "CHANNEL_UPDATE");
    }

    @Override
    public void handle(JSONObject packet) {
        int type = packet.getInt("type");
        if (type == 0) {
            this.handleServerTextChannel(packet, this.api.getServerById(packet.getString("guild_id")));
        } else if (type == 2) {
            this.handleServerVoiceChannel(packet, this.api.getServerById(packet.getString("guild_id")));
        }
    }

    private void handleServerTextChannel(JSONObject packet, Server server) {
        String parentId;
        String topic;
        final Channel channel = server.getChannelById(packet.getString("id"));
        if (channel == null) {
            return;
        }
        String name = packet.getString("name");
        if (!channel.getName().equals(name)) {
            final String oldName = channel.getName();
            ((ImplChannel)channel).setName(name);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ChannelChangeNameListener> listeners;
                    List<ChannelChangeNameListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(ChannelChangeNameListener.class);
                    synchronized (list) {
                        for (ChannelChangeNameListener listener : listeners) {
                            try {
                                listener.onChannelChangeName(ChannelUpdateHandler.this.api, channel, oldName);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ChannelChangeNameListener!", t);
                            }
                        }
                    }
                }
            });
        }
        String string = topic = packet.get("topic") == null ? null : packet.get("topic").toString();
        if (channel.getTopic() != null && topic == null || channel.getTopic() == null && topic != null || channel.getTopic() != null && !channel.getTopic().equals(topic)) {
            final String oldTopic = channel.getTopic();
            ((ImplChannel)channel).setTopic(topic);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ChannelChangeTopicListener> listeners;
                    List<ChannelChangeTopicListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(ChannelChangeTopicListener.class);
                    synchronized (list) {
                        for (ChannelChangeTopicListener listener : listeners) {
                            try {
                                listener.onChannelChangeTopic(ChannelUpdateHandler.this.api, channel, oldTopic);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ChannelChangeTopicListener!", t);
                            }
                        }
                    }
                }
            });
        }
        int position = packet.getInt("position");
        if (channel.getPosition() != position) {
            final int oldPosition = channel.getPosition();
            ((ImplChannel)channel).setPosition(position);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ChannelChangePositionListener> listeners;
                    List<ChannelChangePositionListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(ChannelChangePositionListener.class);
                    synchronized (list) {
                        for (ChannelChangePositionListener listener : listeners) {
                            try {
                                listener.onChannelChangePosition(ChannelUpdateHandler.this.api, channel, oldPosition);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in ChannelChangePositionListener!", t);
                            }
                        }
                    }
                }
            });
        }
        JSONArray permissionOverwrites = packet.getJSONArray("permission_overwrites");
        for (int i = 0; i < permissionOverwrites.length(); ++i) {
            Role role;
            Permissions oldPermissions;
            ImplPermissions permissions;
            JSONObject permissionOverwrite = permissionOverwrites.getJSONObject(i);
            int allow = permissionOverwrite.getInt("allow");
            int deny = permissionOverwrite.getInt("deny");
            String id = permissionOverwrite.getString("id");
            String type = permissionOverwrite.getString("type");
            if (type.equals("member")) {
                User user;
                try {
                    user = this.api.getUserById(id).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    continue;
                }
                permissions = new ImplPermissions(allow, deny);
                oldPermissions = channel.getOverwrittenPermissions(user);
                if (!oldPermissions.equals(permissions)) {
                    ((ImplChannel)channel).setOverwrittenPermissions(user, permissions);
                    this.listenerExecutorService.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<UserChangeOverwrittenPermissionsListener> listeners;
                            List<UserChangeOverwrittenPermissionsListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(UserChangeOverwrittenPermissionsListener.class);
                            synchronized (list) {
                                for (UserChangeOverwrittenPermissionsListener listener : listeners) {
                                    try {
                                        listener.onUserChangeOverwrittenPermissions((DiscordAPI)ChannelUpdateHandler.this.api, user, channel, oldPermissions);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in UserChangeOverwrittenPermissionsListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if (!type.equals("role") || (permissions = new ImplPermissions(allow, deny)).equals(oldPermissions = (role = channel.getServer().getRoleById(id)).getOverwrittenPermissions(channel))) continue;
            ((ImplRole)role).setOverwrittenPermissions(channel, (Permissions)permissions);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<RoleChangeOverwrittenPermissionsListener> listeners;
                    List<RoleChangeOverwrittenPermissionsListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(RoleChangeOverwrittenPermissionsListener.class);
                    synchronized (list) {
                        for (RoleChangeOverwrittenPermissionsListener listener : listeners) {
                            try {
                                listener.onRoleChangeOverwrittenPermissions((DiscordAPI)ChannelUpdateHandler.this.api, role, channel, oldPermissions);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in RoleChangeOverwrittenPermissionsListener!", t);
                            }
                        }
                    }
                }
            });
        }
        String string2 = parentId = packet.isNull("parent_id") ? null : packet.getString("parent_id");
        if (!Objects.deepEquals(channel.getParentId(), parentId)) {
            ((ImplChannel)channel).setParentId(parentId);
        }
    }

    private void handleServerVoiceChannel(JSONObject packet, Server server) {
        String parentId;
        final VoiceChannel channel = server.getVoiceChannelById(packet.getString("id"));
        if (channel == null) {
            return;
        }
        String name = packet.getString("name");
        if (!channel.getName().equals(name)) {
            final String oldName = channel.getName();
            ((ImplVoiceChannel)channel).setName(name);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<VoiceChannelChangeNameListener> listeners;
                    List<VoiceChannelChangeNameListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(VoiceChannelChangeNameListener.class);
                    synchronized (list) {
                        for (VoiceChannelChangeNameListener listener : listeners) {
                            try {
                                listener.onVoiceChannelChangeName(ChannelUpdateHandler.this.api, channel, oldName);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in VoiceChannelChangeNameListener!", t);
                            }
                        }
                    }
                }
            });
        }
        int position = packet.getInt("position");
        if (channel.getPosition() != position) {
            final int oldPosition = channel.getPosition();
            ((ImplVoiceChannel)channel).setPosition(position);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<VoiceChannelChangePositionListener> listeners;
                    List<VoiceChannelChangePositionListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(VoiceChannelChangePositionListener.class);
                    synchronized (list) {
                        for (VoiceChannelChangePositionListener listener : listeners) {
                            try {
                                listener.onVoiceChannelChangePosition(ChannelUpdateHandler.this.api, channel, oldPosition);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in VoiceChannelChangePositionListener!", t);
                            }
                        }
                    }
                }
            });
        }
        JSONArray permissionOverwrites = packet.getJSONArray("permission_overwrites");
        for (int i = 0; i < permissionOverwrites.length(); ++i) {
            Role role;
            Permissions oldPermissions;
            ImplPermissions permissions;
            JSONObject permissionOverwrite = permissionOverwrites.getJSONObject(i);
            int allow = permissionOverwrite.getInt("allow");
            int deny = permissionOverwrite.getInt("deny");
            String id = permissionOverwrite.getString("id");
            String type = permissionOverwrite.getString("type");
            if (type.equals("member")) {
                User user;
                try {
                    user = this.api.getUserById(id).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    continue;
                }
                permissions = new ImplPermissions(allow, deny);
                oldPermissions = channel.getOverwrittenPermissions(user);
                if (!oldPermissions.equals(permissions)) {
                    ((ImplVoiceChannel)channel).setOverwrittenPermissions(user, permissions);
                    this.listenerExecutorService.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<UserChangeOverwrittenPermissionsListener> listeners;
                            List<UserChangeOverwrittenPermissionsListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(UserChangeOverwrittenPermissionsListener.class);
                            synchronized (list) {
                                for (UserChangeOverwrittenPermissionsListener listener : listeners) {
                                    try {
                                        listener.onUserChangeOverwrittenPermissions((DiscordAPI)ChannelUpdateHandler.this.api, user, channel, oldPermissions);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in UserChangeOverwrittenPermissionsListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if (!type.equals("role") || (permissions = new ImplPermissions(allow, deny)).equals(oldPermissions = (role = channel.getServer().getRoleById(id)).getOverwrittenPermissions(channel))) continue;
            ((ImplRole)role).setOverwrittenPermissions(channel, (Permissions)permissions);
            this.listenerExecutorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<RoleChangeOverwrittenPermissionsListener> listeners;
                    List<RoleChangeOverwrittenPermissionsListener> list = listeners = ChannelUpdateHandler.this.api.getListeners(RoleChangeOverwrittenPermissionsListener.class);
                    synchronized (list) {
                        for (RoleChangeOverwrittenPermissionsListener listener : listeners) {
                            try {
                                listener.onRoleChangeOverwrittenPermissions((DiscordAPI)ChannelUpdateHandler.this.api, role, channel, oldPermissions);
                            }
                            catch (Throwable t) {
                                logger.warn("Uncaught exception in RoleChangeOverwrittenPermissionsListener!", t);
                            }
                        }
                    }
                }
            });
        }
        String string = parentId = packet.isNull("parent_id") ? null : packet.getString("parent_id");
        if (!Objects.deepEquals(channel.getParentId(), parentId)) {
            ((ImplVoiceChannel)channel).setParentId(parentId);
        }
    }
}

