/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils;

import de.btobastian.javacord.utils.JavacordLogger;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    private static volatile boolean initialized = false;
    private static final Object initLock = new Object();
    private static final HashMap<String, Logger> loggers = new HashMap();
    private static volatile boolean noLogger = false;
    private static volatile boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        HashMap<String, Logger> hashMap = initLock;
        synchronized (hashMap) {
            if (!initialized) {
                LoggerUtil.init();
            }
        }
        if (noLogger) {
            hashMap = loggers;
            synchronized (hashMap) {
                Logger logger = loggers.get(name);
                if (logger == null) {
                    logger = new JavacordLogger(name);
                    loggers.put(name, logger);
                }
                return logger;
            }
        }
        return LoggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerUtil.getLogger(clazz.getName());
    }

    public static void setDebug(boolean debug) {
        LoggerUtil.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }

    private static void init() {
        initialized = true;
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
        }
        catch (ClassNotFoundException e) {
            noLogger = true;
            LoggerUtil.getLogger(LoggerUtil.class).info("No SLF4J compatible logger was found. Using default javacord implementation!");
        }
    }
}

