/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils;

import com.google.common.util.concurrent.SettableFuture;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import de.btobastian.javacord.utils.handler.ReadyHandler;
import de.btobastian.javacord.utils.handler.ResumedHandler;
import de.btobastian.javacord.utils.handler.channel.ChannelCreateHandler;
import de.btobastian.javacord.utils.handler.channel.ChannelDeleteHandler;
import de.btobastian.javacord.utils.handler.channel.ChannelUpdateHandler;
import de.btobastian.javacord.utils.handler.message.MessageAckHandler;
import de.btobastian.javacord.utils.handler.message.MessageBulkDeleteHandler;
import de.btobastian.javacord.utils.handler.message.MessageCreateHandler;
import de.btobastian.javacord.utils.handler.message.MessageDeleteHandler;
import de.btobastian.javacord.utils.handler.message.MessageReactionAddHandler;
import de.btobastian.javacord.utils.handler.message.MessageReactionRemoveHandler;
import de.btobastian.javacord.utils.handler.message.MessageUpdateHandler;
import de.btobastian.javacord.utils.handler.message.TypingStartHandler;
import de.btobastian.javacord.utils.handler.server.GuildBanAddHandler;
import de.btobastian.javacord.utils.handler.server.GuildBanRemoveHandler;
import de.btobastian.javacord.utils.handler.server.GuildCreateHandler;
import de.btobastian.javacord.utils.handler.server.GuildDeleteHandler;
import de.btobastian.javacord.utils.handler.server.GuildMemberAddHandler;
import de.btobastian.javacord.utils.handler.server.GuildMemberRemoveHandler;
import de.btobastian.javacord.utils.handler.server.GuildMemberUpdateHandler;
import de.btobastian.javacord.utils.handler.server.GuildMembersChunkHandler;
import de.btobastian.javacord.utils.handler.server.GuildUpdateHandler;
import de.btobastian.javacord.utils.handler.server.role.GuildRoleCreateHandler;
import de.btobastian.javacord.utils.handler.server.role.GuildRoleDeleteHandler;
import de.btobastian.javacord.utils.handler.server.role.GuildRoleUpdateHandler;
import de.btobastian.javacord.utils.handler.user.PresenceUpdateHandler;
import de.btobastian.javacord.utils.handler.user.UserGuildSettingsUpdateHandler;
import de.btobastian.javacord.utils.handler.voice.VoiceStateUpdateHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.net.ssl.SSLContext;
import org.json.JSONObject;
import org.slf4j.Logger;

public class DiscordWebsocketAdapter
extends WebSocketAdapter {
    private static final Logger logger = LoggerUtil.getLogger(DiscordWebsocketAdapter.class);
    private final ImplDiscordAPI api;
    private final HashMap<String, PacketHandler> handlers = new HashMap();
    private final SettableFuture<Boolean> ready = SettableFuture.create();
    private final String gateway;
    private WebSocket websocket = null;
    private Timer heartbeatTimer = null;
    private int heartbeatInterval = -1;
    private int lastSeq = -1;
    private String sessionId = null;
    private boolean heartbeatAckReceived = false;
    private boolean reconnect = true;
    private long lastGuildMembersChunkReceived = System.currentTimeMillis();
    private Queue<Long> ratelimitQueue = new LinkedList<Long>();
    private int reconnectAttempts = 5;
    private int ratelimitResetIntervalInSeconds = 300;

    public DiscordWebsocketAdapter(ImplDiscordAPI api, String gateway) {
        this.api = api;
        this.gateway = gateway;
        this.registerHandlers();
        this.connect();
    }

    public void disconnect() {
        this.reconnect = false;
        this.websocket.sendClose(1000);
    }

    private void connect() {
        WebSocketFactory factory = new WebSocketFactory();
        try {
            factory.setSSLContext(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("An error occurred while setting ssl context", e);
        }
        try {
            this.websocket = factory.createSocket(this.gateway + "?encoding=json&v=6");
            this.websocket.addHeader("Accept-Encoding", "gzip");
            this.websocket.addListener(this);
            this.websocket.connect();
        }
        catch (WebSocketException | IOException e) {
            logger.warn("An error occurred while connecting to websocket", e);
        }
    }

    @Override
    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
        if (this.sessionId == null) {
            this.sendIdentify(websocket);
        } else {
            this.sendResume(websocket);
        }
    }

    @Override
    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
        if (closedByServer) {
            logger.info("Websocket closed with reason {} and code {} by server!", (Object)(serverCloseFrame != null ? serverCloseFrame.getCloseReason() : "unknown"), serverCloseFrame != null ? Integer.valueOf(serverCloseFrame.getCloseCode()) : "unknown");
        } else {
            switch (clientCloseFrame == null ? -1 : clientCloseFrame.getCloseCode()) {
                case 1002: 
                case 1008: {
                    logger.debug("Websocket closed! Trying to resume connection.");
                    break;
                }
                default: {
                    logger.info("Websocket closed with reason {} and code {} by client!", (Object)(clientCloseFrame != null ? clientCloseFrame.getCloseReason() : "unknown"), clientCloseFrame != null ? Integer.valueOf(clientCloseFrame.getCloseCode()) : "unknown");
                }
            }
        }
        if (!this.ready.isDone()) {
            this.ready.set(false);
            return;
        }
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel();
            this.heartbeatTimer = null;
        }
        if (this.reconnect) {
            this.ratelimitQueue.offer(System.currentTimeMillis());
            if (this.ratelimitQueue.size() > this.reconnectAttempts) {
                long timestamp = this.ratelimitQueue.poll();
                if (System.currentTimeMillis() - (long)(1000 * this.ratelimitResetIntervalInSeconds) < timestamp) {
                    logger.error("Websocket connection failed more than {} times in the last {} seconds! Stopping reconnecting.", (Object)this.reconnectAttempts, (Object)this.ratelimitResetIntervalInSeconds);
                    return;
                }
            }
            this.connect();
        }
    }

    @Override
    public void onTextMessage(WebSocket websocket, String text) throws Exception {
        JSONObject packet = new JSONObject(text);
        int op = packet.getInt("op");
        switch (op) {
            case 0: {
                this.lastSeq = packet.getInt("s");
                String type = packet.getString("t");
                PacketHandler handler = this.handlers.get(type);
                if (handler != null) {
                    handler.handlePacket(packet.getJSONObject("d"));
                } else {
                    logger.debug("Received unknown packet of type {} (packet: {})", (Object)type, (Object)packet.toString());
                }
                if (type.equals("GUILD_MEMBERS_CHUNK")) {
                    this.lastGuildMembersChunkReceived = System.currentTimeMillis();
                }
                if (type.equals("RESUMED")) {
                    this.heartbeatAckReceived = true;
                    this.heartbeatTimer = this.startHeartbeat(websocket, this.heartbeatInterval);
                    logger.debug("Received RESUMED packet");
                }
                if (type.equals("READY") && this.sessionId == null) {
                    this.heartbeatAckReceived = true;
                    this.heartbeatTimer = this.startHeartbeat(websocket, this.heartbeatInterval);
                    this.sessionId = packet.getJSONObject("d").getString("session_id");
                    if (this.api.isWaitingForServersOnStartup()) {
                        this.api.getThreadPool().getSingleThreadExecutorService("startupWait").submit(new Runnable(){

                            @Override
                            public void run() {
                                int amount = DiscordWebsocketAdapter.this.api.getServers().size();
                                while (true) {
                                    try {
                                        Thread.sleep(1500L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (DiscordWebsocketAdapter.this.api.getServers().size() <= amount && DiscordWebsocketAdapter.this.lastGuildMembersChunkReceived + 1500L < System.currentTimeMillis()) break;
                                    amount = DiscordWebsocketAdapter.this.api.getServers().size();
                                }
                                DiscordWebsocketAdapter.this.ready.set(true);
                            }
                        });
                    } else {
                        this.ready.set(true);
                    }
                    logger.debug("Received READY packet");
                    break;
                }
                if (!type.equals("READY")) break;
                this.heartbeatAckReceived = true;
                this.heartbeatTimer = this.startHeartbeat(websocket, this.heartbeatInterval);
                break;
            }
            case 1: {
                this.sendHeartbeat(websocket);
                break;
            }
            case 7: {
                logger.debug("Received op 7 packet. Reconnecting...");
                websocket.sendClose(1000);
                this.connect();
                break;
            }
            case 9: {
                logger.info("Could not resume session. Reconnecting now...");
                this.sendIdentify(websocket);
                break;
            }
            case 10: {
                JSONObject data = packet.getJSONObject("d");
                this.heartbeatInterval = data.getInt("heartbeat_interval");
                logger.debug("Received HELLO packet");
                break;
            }
            case 11: {
                this.heartbeatAckReceived = true;
                break;
            }
            default: {
                logger.debug("Received unknown packet (op: {}, content: {})", (Object)op, (Object)packet.toString());
            }
        }
    }

    @Override
    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
        Inflater decompressor = new Inflater();
        decompressor.setInput(binary);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(binary.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            int count;
            try {
                count = decompressor.inflate(buf);
            }
            catch (DataFormatException e) {
                logger.warn("An error occurred while decompressing data", e);
                return;
            }
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException count) {
            // empty catch block
        }
        byte[] decompressedData = bos.toByteArray();
        try {
            this.onTextMessage(websocket, new String(decompressedData, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("An error occurred while decompressing data", e);
        }
    }

    private Timer startHeartbeat(final WebSocket websocket, final int heartbeatInterval) {
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DiscordWebsocketAdapter.this.heartbeatAckReceived = false;
                DiscordWebsocketAdapter.this.sendHeartbeat(websocket);
                logger.debug("Sent heartbeat (interval: {})", (Object)heartbeatInterval);
            }
        }, 0L, (long)heartbeatInterval);
        return timer;
    }

    private void sendHeartbeat(WebSocket websocket) {
        JSONObject heartbeatPacket = new JSONObject();
        heartbeatPacket.put("op", 1);
        heartbeatPacket.put("d", this.lastSeq);
        websocket.sendText(heartbeatPacket.toString());
    }

    private void sendResume(WebSocket websocket) {
        JSONObject resumePacket = new JSONObject().put("op", 6).put("d", new JSONObject().put("token", this.api.getToken()).put("session_id", this.sessionId).put("seq", this.lastSeq));
        logger.debug("Sending resume packet");
        websocket.sendText(resumePacket.toString());
    }

    private void sendIdentify(WebSocket websocket) {
        JSONObject identifyPacket = new JSONObject().put("op", 2).put("d", new JSONObject().put("token", this.api.getToken()).put("properties", new JSONObject().put("$os", System.getProperty("os.name")).put("$browser", "Javacord").put("$device", "Javacord").put("$referrer", "").put("$referring_domain", "")).put("compress", true).put("large_threshold", 250));
        logger.debug("Sending identify packet");
        websocket.sendText(identifyPacket.toString());
    }

    private void registerHandlers() {
        this.addHandler(new ReadyHandler(this.api));
        this.addHandler(new ResumedHandler(this.api));
        this.addHandler(new ChannelCreateHandler(this.api));
        this.addHandler(new ChannelDeleteHandler(this.api));
        this.addHandler(new ChannelUpdateHandler(this.api));
        this.addHandler(new MessageAckHandler(this.api));
        this.addHandler(new MessageBulkDeleteHandler(this.api));
        this.addHandler(new MessageCreateHandler(this.api));
        this.addHandler(new MessageDeleteHandler(this.api));
        this.addHandler(new MessageReactionAddHandler(this.api));
        this.addHandler(new MessageReactionRemoveHandler(this.api));
        this.addHandler(new MessageUpdateHandler(this.api));
        this.addHandler(new TypingStartHandler(this.api));
        this.addHandler(new GuildBanAddHandler(this.api));
        this.addHandler(new GuildBanRemoveHandler(this.api));
        this.addHandler(new GuildCreateHandler(this.api));
        this.addHandler(new GuildDeleteHandler(this.api));
        this.addHandler(new GuildMemberAddHandler(this.api));
        this.addHandler(new GuildMemberRemoveHandler(this.api));
        this.addHandler(new GuildMembersChunkHandler(this.api));
        this.addHandler(new GuildMemberUpdateHandler(this.api));
        this.addHandler(new GuildUpdateHandler(this.api));
        this.addHandler(new GuildRoleCreateHandler(this.api));
        this.addHandler(new GuildRoleDeleteHandler(this.api));
        this.addHandler(new GuildRoleUpdateHandler(this.api));
        this.addHandler(new PresenceUpdateHandler(this.api));
        this.addHandler(new UserGuildSettingsUpdateHandler(this.api));
        this.addHandler(new VoiceStateUpdateHandler(this.api));
    }

    private void addHandler(PacketHandler handler) {
        this.handlers.put(handler.getType(), handler);
    }

    public WebSocket getWebSocket() {
        return this.websocket;
    }

    public Future<Boolean> isReady() {
        return this.ready;
    }

    public void updateStatus() {
        logger.debug("Updating status (game: {}, idle: {})", (Object)(this.api.getGame() == null ? "none" : this.api.getGame()), (Object)this.api.isIdle());
        JSONObject game = new JSONObject();
        game.put("name", this.api.getGame() == null ? JSONObject.NULL : this.api.getGame());
        game.put("type", this.api.getStreamingUrl() == null ? 0 : 1);
        if (this.api.getStreamingUrl() != null) {
            game.put("url", this.api.getStreamingUrl());
        }
        JSONObject updateStatus = new JSONObject().put("op", 3).put("d", new JSONObject().put("status", "online").put("afk", false).put("game", game).put("since", this.api.isIdle() ? Integer.valueOf(1) : JSONObject.NULL));
        logger.debug(updateStatus.toString(2));
        this.websocket.sendText(updateStatus.toString());
    }

    public void setRatelimitResetIntervalInSeconds(int ratelimitResetIntervalInSeconds) {
        this.ratelimitResetIntervalInSeconds = ratelimitResetIntervalInSeconds;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
        switch (cause.getMessage()) {
            case "Flushing frames to the server failed: Connection closed by remote host": 
            case "Flushing frames to the server failed: Socket is closed": 
            case "Flushing frames to the server failed: Connection has been shutdown: javax.net.ssl.SSLException: java.net.SocketException: Connection reset": 
            case "An I/O error occurred while a frame was being read from the web socket: Connection reset": {
                break;
            }
            default: {
                logger.warn("Websocket error!", cause);
            }
        }
    }

    @Override
    public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
        logger.warn("Websocket onUnexpected error!", cause);
    }

    @Override
    public void onConnectError(WebSocket websocket, WebSocketException exception) throws Exception {
        logger.warn("Websocket onConnect error!", exception);
    }
}

