/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.exceptions;

import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.utils.ratelimits.RateLimitManager;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;

public class RateLimitedException
extends Exception {
    private final long retryAfter;
    private final RateLimitType type;
    private final Server server;
    private final Channel channel;
    private final RateLimitManager manager;

    public RateLimitedException(String message, long retryAfter, RateLimitType type, Server server, Channel channel, RateLimitManager manager) {
        super(message);
        this.retryAfter = retryAfter;
        this.type = type;
        this.server = server;
        this.channel = channel;
        this.manager = manager;
    }

    public RateLimitType getType() {
        return this.type;
    }

    public Server getServer() {
        return this.server;
    }

    public long getRetryAfter() {
        return this.retryAfter;
    }

    public long getRetryAt() {
        return System.currentTimeMillis() + this.manager.getRateLimit(this.type, this.server, this.channel);
    }

    public void waitTillRetry() throws InterruptedException {
        long time = this.manager.getRateLimit(this.type, this.server, this.channel);
        if (time < 1L) {
            return;
        }
        Thread.sleep(time);
    }
}

