/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.embed.impl;

import de.btobastian.javacord.entities.message.embed.EmbedFooter;
import de.btobastian.javacord.utils.LoggerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplEmbedFooter
implements EmbedFooter {
    private static final Logger logger = LoggerUtil.getLogger(ImplEmbedFooter.class);
    private String text;
    private String iconUrl;
    private String proxyIconUrl;

    public ImplEmbedFooter(JSONObject data) {
        this.text = data.has("text") ? data.getString("text") : null;
        this.iconUrl = data.has("icon_url") ? data.getString("icon_url") : null;
        this.proxyIconUrl = data.has("proxy_icon_url") ? data.getString("proxy_icon_url") : null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public URL getIconUrl() {
        if (this.iconUrl == null) {
            return null;
        }
        try {
            return new URL(this.iconUrl);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the icon url of the embed footer is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public URL getProxyIconUrl() {
        if (this.proxyIconUrl == null) {
            return null;
        }
        try {
            return new URL(this.proxyIconUrl);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the proxy icon url of the embed footer is malformed! Please contact the developer!", e);
            return null;
        }
    }
}

