/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.embed;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class EmbedBuilder {
    private String title = null;
    private String description = null;
    private String url = null;
    private Color color = null;
    private String footerText = null;
    private String footerIconUrl = null;
    private String imageUrl = null;
    private String authorName = null;
    private String authorUrl = null;
    private String authorIconUrl = null;
    private String thumbnailUrl = null;
    private List<Object[]> fields = new ArrayList<Object[]>();

    public EmbedBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public EmbedBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public EmbedBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public EmbedBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public EmbedBuilder setFooter(String text) {
        return this.setFooter(text, null);
    }

    public EmbedBuilder setFooter(String text, String iconUrl) {
        this.footerText = text;
        this.footerIconUrl = iconUrl;
        return this;
    }

    public EmbedBuilder setImage(String url) {
        this.imageUrl = url;
        return this;
    }

    public EmbedBuilder setAuthor(String name) {
        return this.setAuthor(name, null, null);
    }

    public EmbedBuilder setAuthor(String name, String url, String iconUrl) {
        this.authorName = name;
        this.authorUrl = url;
        this.authorIconUrl = iconUrl;
        return this;
    }

    public EmbedBuilder setThumbnail(String url) {
        this.thumbnailUrl = url;
        return this;
    }

    public EmbedBuilder addField(String name, String value, boolean inline) {
        this.fields.add(new Object[]{name, value, inline});
        return this;
    }

    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put("type", "rich");
        if (this.title != null) {
            object.put("title", this.title);
        }
        if (this.description != null) {
            object.put("description", this.description);
        }
        if (this.url != null) {
            object.put("url", this.url);
        }
        if (this.color != null) {
            object.put("color", this.color.getRGB() & 0xFFFFFF);
        }
        if (this.footerText != null) {
            JSONObject footer = new JSONObject();
            footer.put("text", this.footerText);
            if (this.footerIconUrl != null) {
                footer.put("icon_url", this.footerIconUrl);
            }
            object.put("footer", footer);
        }
        if (this.imageUrl != null) {
            object.put("image", new JSONObject().put("url", this.imageUrl));
        }
        if (this.authorName != null) {
            JSONObject author = new JSONObject();
            author.put("name", this.authorName);
            if (this.authorUrl != null) {
                author.put("url", this.authorUrl);
            }
            if (this.authorIconUrl != null) {
                author.put("icon_url", this.authorIconUrl);
            }
            object.put("author", author);
        }
        if (this.thumbnailUrl != null) {
            object.put("thumbnail", new JSONObject().put("url", this.thumbnailUrl));
        }
        if (this.fields.size() > 0) {
            JSONArray jsonFields = new JSONArray();
            for (Object[] field : this.fields) {
                JSONObject jsonField = new JSONObject();
                if (field[0] != null) {
                    jsonField.put("name", field[0]);
                }
                if (field[1] != null) {
                    jsonField.put("value", field[1]);
                }
                if (field[2] != null) {
                    jsonField.put("inline", (Boolean)field[2]);
                }
                jsonFields.put(jsonField);
            }
            object.put("fields", jsonFields);
        }
        return object;
    }
}

