/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.body.MultipartBody;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.UserStatus;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.MessageHistory;
import de.btobastian.javacord.entities.message.embed.EmbedBuilder;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.entities.message.impl.ImplMessageHistory;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.SnowflakeUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplUser
implements User {
    private static final Logger logger = LoggerUtil.getLogger(ImplUser.class);
    private final ImplDiscordAPI api;
    private final String id;
    private String name;
    private String avatarId = null;
    private final Object userChannelIdLock = new Object();
    private String userChannelId = null;
    private String game = null;
    private final String discriminator;
    private final boolean bot;
    private UserStatus status = UserStatus.OFFLINE;
    private VoiceChannel voiceChannel = null;

    public ImplUser(JSONObject data, ImplDiscordAPI api) {
        this.api = api;
        this.id = data.getString("id");
        if (data.has("username")) {
            this.name = data.getString("username");
        }
        try {
            this.avatarId = data.getString("avatar");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.discriminator = data.has("discriminator") ? data.getString("discriminator") : null;
        this.bot = data.has("bot") && data.getBoolean("bot");
        api.getUserMap().put(this.id, this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Calendar getCreationDate() {
        return SnowflakeUtil.parseDate(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNickname(Server server) {
        return server.getNickname(this);
    }

    @Override
    public boolean hasNickname(Server server) {
        return server.hasNickname(this);
    }

    @Override
    public Future<Void> updateNickname(Server server, String nickname) {
        return server.updateNickname(this, nickname);
    }

    @Override
    public void type() {
        if (this.userChannelId == null) {
            return;
        }
        try {
            logger.debug("Sending typing state to user {}", (Object)this);
            HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/channels/" + this.getUserChannelIdBlocking() + "/typing").header("authorization", this.api.getToken()).asJson();
            this.api.checkResponse(response);
            this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, null);
            logger.debug("Sent typing state to user {}", (Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isYourself() {
        return this.api.getYourself() == this;
    }

    @Override
    public Future<byte[]> getAvatarAsByteArray() {
        return this.getAvatarAsByteArray(null);
    }

    @Override
    public Future<byte[]> getAvatarAsByteArray(FutureCallback<byte[]> callback) {
        ListenableFuture<byte[]> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                int n;
                logger.debug("Trying to get avatar from user {}", (Object)ImplUser.this);
                if (ImplUser.this.avatarId == null) {
                    logger.debug("User {} seems to have no avatar. Returning empty array!", (Object)ImplUser.this);
                    return new byte[0];
                }
                URL url = new URL("https://discordapp.com/api/v6/users/" + ImplUser.this.id + "/avatars/" + ImplUser.this.avatarId + ".jpg");
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                conn.setRequestProperty("User-Agent", "DiscordBot (https://github.com/BtoBastian/Javacord, v2.0.17)");
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while (-1 != (n = ((InputStream)in).read(buf))) {
                    out.write(buf, 0, n);
                }
                out.close();
                ((InputStream)in).close();
                byte[] avatar = out.toByteArray();
                logger.debug("Got avatar from user {} (size: {})", (Object)ImplUser.this, (Object)avatar.length);
                return avatar;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<BufferedImage> getAvatar() {
        return this.getAvatar(null);
    }

    @Override
    public Future<BufferedImage> getAvatar(FutureCallback<BufferedImage> callback) {
        ListenableFuture<BufferedImage> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                byte[] imageAsBytes = ImplUser.this.getAvatarAsByteArray().get();
                if (imageAsBytes.length == 0) {
                    return null;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(imageAsBytes);
                return ImageIO.read(in);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public URL getAvatarUrl() {
        if (this.avatarId == null) {
            return null;
        }
        try {
            return new URL("https://discordapp.com/api/v6/users/" + this.id + "/avatars/" + this.avatarId + ".jpg");
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the avatar is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public String getAvatarId() {
        return this.avatarId;
    }

    @Override
    public Future<Message> sendMessage(String content) {
        return this.sendMessage(content, null, false, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, String nonce) {
        return this.sendMessage(content, null, false, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts) {
        return this.sendMessage(content, null, tts, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts, String nonce) {
        return this.sendMessage(content, null, tts, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed) {
        return this.sendMessage(content, embed, false, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, String nonce) {
        return this.sendMessage(content, embed, false, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, boolean tts) {
        return this.sendMessage(content, embed, tts, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, String nonce) {
        return this.sendMessage(content, embed, tts, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, false, null, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, String nonce, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, false, nonce, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, tts, null, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts, String nonce, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, tts, nonce, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, FutureCallback<Message> callback) {
        return this.sendMessage(content, embed, false, null, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, String nonce, FutureCallback<Message> callback) {
        return this.sendMessage(content, embed, false, nonce, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, FutureCallback<Message> callback) {
        return this.sendMessage(content, embed, tts, null, callback);
    }

    @Override
    public Future<Message> sendMessage(final String content, final EmbedBuilder embed, final boolean tts, final String nonce, FutureCallback<Message> callback) {
        final ImplUser receiver = this;
        ListenableFuture<Message> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                logger.debug("Trying to send message to user {} (content: \"{}\", tts: {})", ImplUser.this, content, tts);
                ImplUser.this.api.checkRateLimit(null, RateLimitType.PRIVATE_MESSAGE, null, null);
                JSONObject body = new JSONObject().put("content", content).put("tts", tts).put("mentions", new String[0]);
                if (embed != null) {
                    body.put("embed", embed.toJSONObject());
                }
                if (nonce != null) {
                    body.put("nonce", nonce);
                }
                HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplUser.this.getUserChannelIdBlocking() + "/messages").header("authorization", ImplUser.this.api.getToken()).header("content-type", "application/json").body(body.toString()).asJson();
                ImplUser.this.api.checkResponse(response);
                ImplUser.this.api.checkRateLimit(response, RateLimitType.PRIVATE_MESSAGE, null, null);
                logger.debug("Sent message to user {} (content: \"{}\", tts: {})", ImplUser.this, content, tts);
                return new ImplMessage(response.getBody().getObject(), ImplUser.this.api, receiver);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Message> sendFile(File file) {
        return this.sendFile(file, null, null);
    }

    @Override
    public Future<Message> sendFile(File file, FutureCallback<Message> callback) {
        return this.sendFile(file, null, callback);
    }

    @Override
    public Future<Message> sendFile(InputStream inputStream, String filename) {
        return this.sendFile(inputStream, filename, null, null);
    }

    @Override
    public Future<Message> sendFile(InputStream inputStream, String filename, FutureCallback<Message> callback) {
        return this.sendFile(inputStream, filename, null, callback);
    }

    @Override
    public Future<Message> sendFile(File file, String comment) {
        return this.sendFile(file, comment, null);
    }

    @Override
    public Future<Message> sendFile(final File file, final String comment, FutureCallback<Message> callback) {
        final ImplUser receiver = this;
        ListenableFuture<Message> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                logger.debug("Trying to send a file to user {} (name: {}, comment: {})", ImplUser.this, file.getName(), comment);
                ImplUser.this.api.checkRateLimit(null, RateLimitType.PRIVATE_MESSAGE, null, null);
                MultipartBody body = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplUser.this.getUserChannelIdBlocking() + "/messages").header("authorization", ImplUser.this.api.getToken()).field("file", file);
                if (comment != null) {
                    body.field("content", comment);
                }
                HttpResponse<JsonNode> response = body.asJson();
                ImplUser.this.api.checkResponse(response);
                ImplUser.this.api.checkRateLimit(response, RateLimitType.PRIVATE_MESSAGE, null, null);
                logger.debug("Sent a file to user {} (name: {}, comment: {})", ImplUser.this, file.getName(), comment);
                return new ImplMessage(response.getBody().getObject(), ImplUser.this.api, receiver);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Message> sendFile(InputStream inputStream, String filename, String comment) {
        return this.sendFile(inputStream, filename, comment, null);
    }

    @Override
    public Future<Message> sendFile(final InputStream inputStream, final String filename, final String comment, FutureCallback<Message> callback) {
        final ImplUser receiver = this;
        ListenableFuture<Message> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                logger.debug("Trying to send an input stream to user {} (comment: {})", (Object)ImplUser.this, (Object)comment);
                ImplUser.this.api.checkRateLimit(null, RateLimitType.PRIVATE_MESSAGE, null, null);
                MultipartBody body = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplUser.this.getUserChannelIdBlocking() + "/messages").header("authorization", ImplUser.this.api.getToken()).field("file", inputStream, filename);
                if (comment != null) {
                    body.field("content", comment);
                }
                HttpResponse<JsonNode> response = body.asJson();
                ImplUser.this.api.checkResponse(response);
                ImplUser.this.api.checkRateLimit(response, RateLimitType.PRIVATE_MESSAGE, null, null);
                logger.debug("Sent an input stream to user {} (comment: {})", (Object)ImplUser.this, (Object)comment);
                return new ImplMessage(response.getBody().getObject(), ImplUser.this.api, receiver);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Collection<Role> getRoles(Server server) {
        ArrayList<Role> userRoles = new ArrayList<Role>();
        for (Role role : server.getRoles()) {
            if (!role.getUsers().contains(this)) continue;
            userRoles.add(role);
        }
        return userRoles;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public Future<MessageHistory> getMessageHistory(int limit) {
        return this.getMessageHistory(null, false, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistory(int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(null, false, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(Message before, int limit) {
        return this.getMessageHistory(before.getId(), true, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(Message before, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(before.getId(), true, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(String beforeId, int limit) {
        return this.getMessageHistory(beforeId, true, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(String beforeId, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(beforeId, true, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(Message after, int limit) {
        return this.getMessageHistory(after.getId(), false, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(Message after, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(after.getId(), false, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(String afterId, int limit) {
        return this.getMessageHistory(afterId, false, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(String afterId, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(afterId, false, limit, callback);
    }

    @Override
    public String getMentionTag() {
        return "<@" + this.getId() + ">";
    }

    @Override
    public String getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public boolean isBot() {
        return this.bot;
    }

    @Override
    public UserStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    private Future<MessageHistory> getMessageHistory(final String messageId, final boolean before, final int limit, FutureCallback<MessageHistory> callback) {
        ListenableFuture<MessageHistory> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<MessageHistory>(){

            @Override
            public MessageHistory call() throws Exception {
                ImplMessageHistory history = new ImplMessageHistory(ImplUser.this.api, ImplUser.this.getUserChannelIdBlocking(), messageId, before, limit);
                ImplUser.this.api.addHistory(history);
                return history;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserChannelId(String userChannelId) {
        Object object = this.userChannelIdLock;
        synchronized (object) {
            this.userChannelId = userChannelId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserChannelIdBlocking() throws Exception {
        Object object = this.userChannelIdLock;
        synchronized (object) {
            if (this.userChannelId != null) {
                return this.userChannelId;
            }
            logger.debug("Trying to get channel id of user {}", (Object)this);
            HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/users/" + this.api.getYourself().getId() + "/channels").header("authorization", this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("recipient_id", this.id).toString()).asJson();
            this.api.checkResponse(response);
            this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, null);
            this.userChannelId = response.getBody().getObject().getString("id");
            logger.debug("Got channel id of user {} (channel id: {})", (Object)this, (Object)this.userChannelId);
            return this.userChannelId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserChannelId() {
        Object object = this.userChannelIdLock;
        synchronized (object) {
            return this.userChannelId;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGame(String game) {
        this.game = game;
    }

    public void setAvatarId(String avatarId) {
        this.avatarId = avatarId;
    }

    public void setVoiceChannel(VoiceChannel voiceChannel) {
        this.voiceChannel = voiceChannel;
    }

    @Override
    public final VoiceChannel getVoiceChannel() {
        return this.voiceChannel;
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

