/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.CustomEmoji;
import de.btobastian.javacord.entities.Invite;
import de.btobastian.javacord.entities.Region;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.UserStatus;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.impl.ImplChannel;
import de.btobastian.javacord.entities.impl.ImplCustomEmoji;
import de.btobastian.javacord.entities.impl.ImplInvite;
import de.btobastian.javacord.entities.impl.ImplUser;
import de.btobastian.javacord.entities.impl.ImplVoiceChannel;
import de.btobastian.javacord.entities.permissions.Ban;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplBan;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.channel.ChannelCreateListener;
import de.btobastian.javacord.listener.role.RoleCreateListener;
import de.btobastian.javacord.listener.server.ServerChangeNameListener;
import de.btobastian.javacord.listener.server.ServerLeaveListener;
import de.btobastian.javacord.listener.server.ServerMemberBanListener;
import de.btobastian.javacord.listener.server.ServerMemberRemoveListener;
import de.btobastian.javacord.listener.server.ServerMemberUnbanListener;
import de.btobastian.javacord.listener.user.UserRoleAddListener;
import de.btobastian.javacord.listener.user.UserRoleRemoveListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelCreateListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.SnowflakeUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplServer
implements Server {
    private static final Logger logger = LoggerUtil.getLogger(ImplServer.class);
    private final ImplDiscordAPI api;
    private final ConcurrentHashMap<String, Channel> channels = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, VoiceChannel> voiceChannels = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, User> members = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Role> roles = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CustomEmoji> customEmojis = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nicknames = new ConcurrentHashMap();
    private final String id;
    private String name;
    private Region region;
    private int memberCount;
    private final boolean large;
    private String ownerId;
    private String iconHash;

    public ImplServer(JSONObject data, ImplDiscordAPI api) {
        this.api = api;
        this.name = data.getString("name");
        this.id = data.getString("id");
        this.region = Region.getRegionByKey(data.getString("region"));
        this.memberCount = data.getInt("member_count");
        this.large = data.getBoolean("large");
        this.ownerId = data.getString("owner_id");
        JSONArray roles = data.getJSONArray("roles");
        for (int i = 0; i < roles.length(); ++i) {
            new ImplRole(roles.getJSONObject(i), this, api);
        }
        JSONArray emojis = data.getJSONArray("emojis");
        for (int i = 0; i < emojis.length(); ++i) {
            new ImplCustomEmoji(emojis.getJSONObject(i), this, api);
        }
        JSONArray channels = data.getJSONArray("channels");
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channelJson = channels.getJSONObject(i);
            int type = channelJson.getInt("type");
            if (type == 0) {
                new ImplChannel(channels.getJSONObject(i), this, api);
            }
            if (type != 2) continue;
            new ImplVoiceChannel(channels.getJSONObject(i), this, api);
        }
        JSONArray members = new JSONArray();
        if (data.has("members")) {
            members = data.getJSONArray("members");
        }
        this.addMembers(members);
        if (!api.isLazyLoading() && this.isLarge() && this.getMembers().size() < this.getMemberCount()) {
            JSONObject requestGuildMembersPacket = new JSONObject().put("op", 8).put("d", new JSONObject().put("guild_id", this.getId()).put("query", "").put("limit", 0));
            logger.debug("Sending request guild members packet for server {}", (Object)this);
            api.getSocketAdapter().getWebSocket().sendText(requestGuildMembersPacket.toString());
        }
        JSONArray voiceStates = new JSONArray();
        if (data.has("voice_states")) {
            voiceStates = data.getJSONArray("voice_states");
        }
        for (int i = 0; i < voiceStates.length(); ++i) {
            VoiceChannel channel;
            User user;
            JSONObject voiceState = voiceStates.getJSONObject(i);
            if (!voiceState.has("user_id") || voiceState.isNull("user_id") || (user = api.getCachedUserById(voiceState.getString("user_id"))) == null || !voiceState.has("channel_id") || voiceState.isNull("channel_id") || (channel = this.getVoiceChannelById(voiceState.getString("channel_id"))) == null) continue;
            ((ImplVoiceChannel)channel).addConnectedUser(user);
            ((ImplUser)user).setVoiceChannel(channel);
        }
        JSONArray presences = new JSONArray();
        if (data.has("presences")) {
            presences = data.getJSONArray("presences");
        }
        for (int i = 0; i < presences.length(); ++i) {
            JSONObject presence = presences.getJSONObject(i);
            User user = api.getOrCreateUser(presence.getJSONObject("user"));
            if (user != null && presence.has("game") && !presence.isNull("game") && presence.getJSONObject("game").has("name") && !presence.getJSONObject("game").isNull("name")) {
                ((ImplUser)user).setGame(presence.getJSONObject("game").getString("name"));
            }
            if (user == null || !presence.has("status") || presence.isNull("status")) continue;
            UserStatus status = UserStatus.fromString(presence.getString("status"));
            ((ImplUser)user).setStatus(status);
        }
        this.iconHash = data.isNull("icon") ? null : data.getString("icon");
        api.getServerMap().put(this.id, this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Calendar getCreationDate() {
        return SnowflakeUtil.parseDate(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Future<Void> delete() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete server {}", (Object)ImplServer.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/guilds/" + ImplServer.this.id).header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                ImplServer.this.api.getServerMap().remove(ImplServer.this.id);
                logger.info("Deleted server {}", (Object)ImplServer.this);
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ServerLeaveListener> listeners;
                        List<ServerLeaveListener> list = listeners = ImplServer.this.api.getListeners(ServerLeaveListener.class);
                        synchronized (list) {
                            for (ServerLeaveListener listener : listeners) {
                                try {
                                    listener.onServerLeave(ImplServer.this.api, ImplServer.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in ServerLeaveListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Future<Void> leave() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to leave server {}", (Object)ImplServer.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/users/@me/guilds/" + ImplServer.this.id).header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                ImplServer.this.api.getServerMap().remove(ImplServer.this.id);
                logger.info("Left server {}", (Object)ImplServer.this);
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ServerLeaveListener> listeners;
                        List<ServerLeaveListener> list = listeners = ImplServer.this.api.getListeners(ServerLeaveListener.class);
                        synchronized (list) {
                            for (ServerLeaveListener listener : listeners) {
                                try {
                                    listener.onServerLeave(ImplServer.this.api, ImplServer.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in ServerLeaveListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Channel getChannelById(String id) {
        return this.channels.get(id);
    }

    @Override
    public Collection<Channel> getChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        return this.voiceChannels.get(id);
    }

    @Override
    public Collection<VoiceChannel> getVoiceChannels() {
        return Collections.unmodifiableCollection(this.voiceChannels.values());
    }

    @Override
    public User getMemberById(String id) {
        return this.members.get(id);
    }

    @Override
    public Collection<User> getMembers() {
        return Collections.unmodifiableCollection(this.members.values());
    }

    @Override
    public boolean isMember(User user) {
        return this.isMember(user.getId());
    }

    @Override
    public boolean isMember(String userId) {
        return this.members.containsKey(userId);
    }

    @Override
    public Collection<Role> getRoles() {
        return Collections.unmodifiableCollection(this.roles.values());
    }

    @Override
    public Role getRoleById(String id) {
        return this.roles.get(id);
    }

    @Override
    public Future<Channel> createChannel(String name) {
        return this.createChannel(name, null);
    }

    @Override
    public Future<Channel> createChannel(final String name, FutureCallback<Channel> callback) {
        ListenableFuture<Channel> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Channel>(){

            @Override
            public Channel call() throws Exception {
                final Channel channel = (Channel)ImplServer.this.createChannelBlocking(name, false);
                logger.info("Created channel in server {} (name: {}, voice: {}, id: {})", ImplServer.this, channel.getName(), false, channel.getId());
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ChannelCreateListener> listeners;
                        List<ChannelCreateListener> list = listeners = ImplServer.this.api.getListeners(ChannelCreateListener.class);
                        synchronized (list) {
                            for (ChannelCreateListener listener : listeners) {
                                try {
                                    listener.onChannelCreate(ImplServer.this.api, channel);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in ChannelCreateListener!", t);
                                }
                            }
                        }
                    }
                });
                return channel;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<VoiceChannel> createVoiceChannel(String name) {
        return this.createVoiceChannel(name, null);
    }

    @Override
    public Future<VoiceChannel> createVoiceChannel(final String name, FutureCallback<VoiceChannel> callback) {
        ListenableFuture<VoiceChannel> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<VoiceChannel>(){

            @Override
            public VoiceChannel call() throws Exception {
                final VoiceChannel channel = (VoiceChannel)ImplServer.this.createChannelBlocking(name, true);
                logger.info("Created channel in server {} (name: {}, voice: {}, id: {})", ImplServer.this, channel.getName(), true, channel.getId());
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<VoiceChannelCreateListener> listeners;
                        List<VoiceChannelCreateListener> list = listeners = ImplServer.this.api.getListeners(VoiceChannelCreateListener.class);
                        synchronized (list) {
                            for (VoiceChannelCreateListener listener : listeners) {
                                try {
                                    listener.onVoiceChannelCreate(ImplServer.this.api, channel);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in VoiceChannelCreateListener!", t);
                                }
                            }
                        }
                    }
                });
                return channel;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Invite[]> getInvites() {
        return this.getInvites(null);
    }

    @Override
    public Future<Invite[]> getInvites(FutureCallback<Invite[]> callback) {
        ListenableFuture<Invite[]> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Invite[]>(){

            @Override
            public Invite[] call() throws Exception {
                logger.debug("Trying to get invites for server {}", (Object)ImplServer.this);
                HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/invites").header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                Invite[] invites = new Invite[response.getBody().getArray().length()];
                for (int i = 0; i < response.getBody().getArray().length(); ++i) {
                    invites[i] = new ImplInvite(ImplServer.this.api, response.getBody().getArray().getJSONObject(i));
                }
                logger.debug("Got invites for server {} (amount: {})", (Object)ImplServer.this, (Object)invites.length);
                return invites;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Void> updateRoles(final User user, final Role[] roles) {
        final String[] roleIds = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            roleIds[i] = roles[i].getId();
        }
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to update roles in server {} (amount: {})", (Object)ImplServer.this, (Object)roles.length);
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/members/" + user.getId()).header("authorization", ImplServer.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("roles", roleIds).toString()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                for (final Role role : user.getRoles(ImplServer.this)) {
                    boolean contains = false;
                    for (Role r : roles) {
                        if (role != r) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    ((ImplRole)role).removeUserNoUpdate(user);
                    ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<UserRoleRemoveListener> listeners;
                            List<UserRoleRemoveListener> list = listeners = ImplServer.this.api.getListeners(UserRoleRemoveListener.class);
                            synchronized (list) {
                                for (UserRoleRemoveListener listener : listeners) {
                                    try {
                                        listener.onUserRoleRemove(ImplServer.this.api, user, role);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in UserRoleRemoveListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                for (final Role role : roles) {
                    if (user.getRoles(ImplServer.this).contains(role)) continue;
                    ((ImplRole)role).addUserNoUpdate(user);
                    ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<UserRoleAddListener> listeners;
                            List<UserRoleAddListener> list = listeners = ImplServer.this.api.getListeners(UserRoleAddListener.class);
                            synchronized (list) {
                                for (UserRoleAddListener listener : listeners) {
                                    try {
                                        listener.onUserRoleAdd(ImplServer.this.api, user, role);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in UserRoleAddListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                logger.debug("Updated roles in server {} (amount: {})", (Object)ImplServer.this, (Object)ImplServer.this.getRoles().size());
                return null;
            }
        });
    }

    @Override
    public Future<Void> banUser(User user) {
        return this.banUser(user.getId(), 0);
    }

    @Override
    public Future<Void> banUser(String userId) {
        return this.banUser(userId, 0);
    }

    @Override
    public Future<Void> banUser(User user, int deleteDays) {
        return this.banUser(user.getId(), deleteDays);
    }

    @Override
    public Future<Void> banUser(final String userId, final int deleteDays) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to ban an user from server {} (user id: {}, delete days: {})", ImplServer.this, userId, deleteDays);
                HttpResponse<JsonNode> response = Unirest.put("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/bans/" + userId + "?delete-message-days=" + deleteDays).header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                final User user = ImplServer.this.api.getUserById(userId).get();
                if (user != null) {
                    ImplServer.this.removeMember(user);
                }
                logger.info("Banned an user from server {} (user id: {}, delete days: {})", ImplServer.this, userId, deleteDays);
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ServerMemberBanListener> listeners;
                        List<ServerMemberBanListener> list = listeners = ImplServer.this.api.getListeners(ServerMemberBanListener.class);
                        synchronized (list) {
                            for (ServerMemberBanListener listener : listeners) {
                                try {
                                    listener.onServerMemberBan(ImplServer.this.api, user, ImplServer.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in ServerMemberBanListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Future<Void> unbanUser(final String userId) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to unban an user from server {} (user id: {})", (Object)ImplServer.this, (Object)userId);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/bans/" + userId).header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                logger.info("Unbanned an user from server {} (user id: {})", (Object)ImplServer.this, (Object)userId);
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ServerMemberUnbanListener> listeners;
                        List<ServerMemberUnbanListener> list = listeners = ImplServer.this.api.getListeners(ServerMemberUnbanListener.class);
                        synchronized (list) {
                            for (ServerMemberUnbanListener listener : listeners) {
                                try {
                                    listener.onServerMemberUnban(ImplServer.this.api, userId, ImplServer.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in ServerMemberUnbanListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Future<Ban[]> getBans() {
        return this.getBans(null);
    }

    @Override
    public Future<Ban[]> getBans(FutureCallback<Ban[]> callback) {
        ListenableFuture<Ban[]> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Ban[]>(){

            @Override
            public Ban[] call() throws Exception {
                logger.debug("Trying to get bans for server {}", (Object)ImplServer.this);
                HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/bans").header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                JSONArray bansJson = response.getBody().getArray();
                Ban[] bans = new Ban[bansJson.length()];
                for (int i = 0; i < bansJson.length(); ++i) {
                    bans[i] = new ImplBan(ImplServer.this.api, ImplServer.this, bansJson.getJSONObject(i));
                }
                logger.debug("Got bans for server {} (amount: {})", (Object)ImplServer.this, (Object)bans.length);
                return bans;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Void> kickUser(User user) {
        return this.kickUser(user.getId());
    }

    @Override
    public Future<Void> kickUser(final String userId) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to kick an user from server {} (user id: {})", (Object)ImplServer.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/members/" + userId).header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                final User user = ImplServer.this.api.getUserById(userId).get();
                if (user != null) {
                    ImplServer.this.removeMember(user);
                }
                logger.info("Kicked an user from server {} (user id: {})", (Object)ImplServer.this);
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ServerMemberRemoveListener> listeners;
                        List<ServerMemberRemoveListener> list = listeners = ImplServer.this.api.getListeners(ServerMemberRemoveListener.class);
                        synchronized (list) {
                            for (ServerMemberRemoveListener listener : listeners) {
                                try {
                                    listener.onServerMemberRemove(ImplServer.this.api, user, ImplServer.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in ServerMemberRemoveListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Future<Role> createRole() {
        return this.createRole(null);
    }

    @Override
    public Future<Role> createRole(FutureCallback<Role> callback) {
        ListenableFuture<Role> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Role>(){

            @Override
            public Role call() throws Exception {
                logger.debug("Trying to create a role in server {}", (Object)ImplServer.this);
                HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/roles").header("authorization", ImplServer.this.api.getToken()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                final ImplRole role = new ImplRole(response.getBody().getObject(), ImplServer.this, ImplServer.this.api);
                logger.info("Created role in server {} (name: {}, id: {})", ImplServer.this, role.getName(), role.getId());
                ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<RoleCreateListener> listeners;
                        List<RoleCreateListener> list = listeners = ImplServer.this.api.getListeners(RoleCreateListener.class);
                        synchronized (list) {
                            for (RoleCreateListener listener : listeners) {
                                try {
                                    listener.onRoleCreate(ImplServer.this.api, role);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in RoleCreateListener!", t);
                                }
                            }
                        }
                    }
                });
                return role;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Void> updateName(String newName) {
        return this.update(newName, null, null);
    }

    @Override
    public Future<Void> updateRegion(Region newRegion) {
        return this.update(null, newRegion, null);
    }

    @Override
    public Future<Void> updateIcon(BufferedImage newIcon) {
        return this.update(null, null, newIcon);
    }

    @Override
    public Future<Void> update(final String newName, final Region newRegion, BufferedImage newIcon) {
        final JSONObject params = new JSONObject();
        if (newName == null) {
            params.put("name", this.getName());
        } else {
            params.put("name", newName);
        }
        if (newRegion != null) {
            params.put("region", newRegion.getKey());
        }
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to update server {} (new name: {}, old name: {}, new region: {}, old region: {}", ImplServer.this, newName, ImplServer.this.getName(), newRegion == null ? "null" : newRegion.getKey(), ImplServer.this.getRegion().getKey());
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId()).header("authorization", ImplServer.this.api.getToken()).header("Content-Type", "application/json").body(params.toString()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                logger.debug("Updated server {} (new name: {}, old name: {}, new region: {}, old region: {}", ImplServer.this, newName, ImplServer.this.getName(), newRegion == null ? "null" : newRegion.getKey(), ImplServer.this.getRegion().getKey());
                String name = response.getBody().getObject().getString("name");
                if (!ImplServer.this.getName().equals(name)) {
                    final String oldName = ImplServer.this.getName();
                    ImplServer.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<ServerChangeNameListener> listeners;
                            List<ServerChangeNameListener> list = listeners = ImplServer.this.api.getListeners(ServerChangeNameListener.class);
                            synchronized (list) {
                                for (ServerChangeNameListener listener : listeners) {
                                    try {
                                        listener.onServerChangeName(ImplServer.this.api, ImplServer.this, oldName);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in ServerChangeNameListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public int getMemberCount() {
        return this.memberCount;
    }

    @Override
    public boolean isLarge() {
        return this.large;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public Future<User> getOwner() {
        return this.api.getUserById(this.ownerId);
    }

    @Override
    public Collection<CustomEmoji> getCustomEmojis() {
        return this.customEmojis.values();
    }

    @Override
    public CustomEmoji getCustomEmojiById(String id) {
        return this.customEmojis.get(id);
    }

    @Override
    public CustomEmoji getCustomEmojiByName(String name) {
        for (CustomEmoji emoji : this.customEmojis.values()) {
            if (!emoji.getName().equals(name)) continue;
            return emoji;
        }
        return null;
    }

    @Override
    public String getNickname(User user) {
        return this.nicknames.get(user.getId());
    }

    @Override
    public boolean hasNickname(User user) {
        return this.nicknames.contains(user.getId());
    }

    @Override
    public Future<Void> updateNickname(final User user, final String nickname) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to update nickname of user {} to {}", (Object)user, (Object)nickname);
                String url = "https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/members/" + user.getId();
                if (user.isYourself()) {
                    url = "https://discordapp.com/api/v6/guilds/" + ImplServer.this.getId() + "/members/@me/nick";
                }
                HttpResponse<JsonNode> response = Unirest.patch(url).header("authorization", ImplServer.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("nick", nickname).toString()).asJson();
                ImplServer.this.api.checkResponse(response);
                ImplServer.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplServer.this, null);
                logger.debug("Updated nickname of user {} to {}", (Object)user, (Object)nickname);
                return null;
            }
        });
    }

    @Override
    public URL getIconUrl() {
        if (this.iconHash == null) {
            return null;
        }
        try {
            return new URL("https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconHash + ".png");
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the icon is malformed! Please contact the developer!", e);
            return null;
        }
    }

    public Future<byte[]> getIconAsByteArray() {
        ListenableFuture<byte[]> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                int n;
                logger.debug("Trying to get icon from server {}", (Object)ImplServer.this);
                if (ImplServer.this.iconHash == null) {
                    logger.debug("Server {} has default icon. Returning empty array!", (Object)ImplServer.this);
                    return new byte[0];
                }
                URL url = ImplServer.this.getIconUrl();
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                conn.setRequestProperty("User-Agent", "DiscordBot (https://github.com/BtoBastian/Javacord, v2.0.17)");
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while (-1 != (n = ((InputStream)in).read(buf))) {
                    out.write(buf, 0, n);
                }
                out.close();
                ((InputStream)in).close();
                byte[] avatar = out.toByteArray();
                logger.debug("Got icon from server {} (size: {})", (Object)ImplServer.this, (Object)avatar.length);
                return avatar;
            }
        });
        return future;
    }

    @Override
    public Future<byte[]> getIcon() {
        return this.getIcon(null);
    }

    @Override
    public Future<byte[]> getIcon(FutureCallback<byte[]> callback) {
        ListenableFuture<byte[]> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                byte[] imageAsBytes = ImplServer.this.getIconAsByteArray().get();
                if (imageAsBytes.length == 0) {
                    return null;
                }
                return imageAsBytes;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void addMember(User user) {
        this.members.put(user.getId(), user);
    }

    public void addMembers(JSONArray members) {
        for (int i = 0; i < members.length(); ++i) {
            User member = this.api.getOrCreateUser(members.getJSONObject(i).getJSONObject("user"));
            if (members.getJSONObject(i).has("nick") && !members.getJSONObject(i).isNull("nick")) {
                this.nicknames.put(member.getId(), members.getJSONObject(i).getString("nick"));
            }
            this.members.put(member.getId(), member);
            JSONArray memberRoles = members.getJSONObject(i).getJSONArray("roles");
            for (int j = 0; j < memberRoles.length(); ++j) {
                Role role = this.getRoleById(memberRoles.getString(j));
                if (role == null) continue;
                ((ImplRole)role).addUserNoUpdate(member);
            }
        }
    }

    public void removeMember(User user) {
        this.members.remove(user.getId());
        for (Role role : this.getRoles()) {
            ((ImplRole)role).removeUserNoUpdate(user);
        }
        for (Channel channel : this.getChannels()) {
            ((ImplChannel)channel).removeOverwrittenPermissions(user);
        }
        for (VoiceChannel voiceChannel : this.getVoiceChannels()) {
            ((ImplVoiceChannel)voiceChannel).removeOverwrittenPermissions(user);
        }
    }

    public void incrementMemberCount() {
        ++this.memberCount;
    }

    public void decrementMemberCount() {
        --this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public void addChannel(Channel channel) {
        this.channels.put(channel.getId(), channel);
    }

    public void addVoiceChannel(VoiceChannel channel) {
        this.voiceChannels.put(channel.getId(), channel);
    }

    public void addRole(Role role) {
        this.roles.put(role.getId(), role);
    }

    public void removeRole(Role role) {
        this.roles.remove(role.getId());
    }

    public void removeChannel(Channel channel) {
        this.channels.remove(channel.getId());
    }

    public void removeVoiceChannel(VoiceChannel channel) {
        this.voiceChannels.remove(channel.getId());
    }

    public void addCustomEmoji(CustomEmoji emoji) {
        this.customEmojis.put(emoji.getId(), emoji);
    }

    public void removeCustomEmoji(CustomEmoji emoji) {
        this.customEmojis.remove(emoji.getId());
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public void setNickname(User user, String nickname) {
        if (nickname == null) {
            this.nicknames.remove(user.getId());
        } else {
            this.nicknames.put(user.getId(), nickname);
        }
    }

    public String getIconHash() {
        return this.iconHash;
    }

    public void setIconHash(String hash) {
        this.iconHash = hash;
    }

    private Object createChannelBlocking(String name, boolean voice) throws Exception {
        logger.debug("Trying to create channel in server {} (name: {}, voice: {})", this, name, voice);
        JSONObject param = new JSONObject().put("name", name).put("type", voice ? "voice" : "text");
        HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/guilds/" + this.id + "/channels").header("authorization", this.api.getToken()).header("Content-Type", "application/json").body(param.toString()).asJson();
        this.api.checkResponse(response);
        this.api.checkRateLimit(response, RateLimitType.UNKNOWN, this, null);
        if (voice) {
            return new ImplVoiceChannel(response.getBody().getObject(), this, this.api);
        }
        return new ImplChannel(response.getBody().getObject(), this, this.api);
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

