/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.impl;

import com.google.common.util.concurrent.FutureCallback;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Invite;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.utils.LoggerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.Future;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplInvite
implements Invite {
    private static final Logger logger = LoggerUtil.getLogger(ImplInvite.class);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat FORMAT_ALTERNATIVE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final SimpleDateFormat FORMAT_ALTERNATIVE_TWO = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private final ImplDiscordAPI api;
    private final String code;
    private final String serverId;
    private final String serverName;
    private final String channelId;
    private final String channelName;
    private final boolean voice;
    private int maxAge = -1;
    private boolean revoked = false;
    private Calendar creationDate = null;
    private int uses = -1;
    private int maxUses = -1;
    private boolean temporary = false;
    private User creator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImplInvite(ImplDiscordAPI api, JSONObject data) {
        this.api = api;
        this.code = data.getString("code");
        this.serverId = data.getJSONObject("guild").getString("id");
        this.serverName = data.getJSONObject("guild").getString("name");
        this.channelId = data.getJSONObject("channel").getString("id");
        this.channelName = data.getJSONObject("channel").getString("name");
        boolean bl = this.voice = data.getJSONObject("channel").getInt("type") == 2;
        if (data.has("max_age")) {
            this.maxAge = data.getInt("max_age");
        }
        if (data.has("revoked")) {
            this.revoked = data.getBoolean("revoked");
        }
        if (data.has("created_at")) {
            String time = data.getString("created_at");
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = FORMAT;
            synchronized (simpleDateFormat) {
                try {
                    calendar.setTime(FORMAT.parse(time.substring(0, time.length() - 9)));
                }
                catch (ParseException ignored) {
                    try {
                        calendar.setTime(FORMAT_ALTERNATIVE.parse(time.substring(0, time.length() - 9)));
                    }
                    catch (ParseException ignored2) {
                        try {
                            calendar.setTime(FORMAT_ALTERNATIVE_TWO.parse(time.substring(0, time.length() - 9)));
                        }
                        catch (ParseException e) {
                            logger.warn("Could not parse timestamp {}. Please contact the developer!", (Object)time, (Object)e);
                        }
                    }
                }
            }
            this.creationDate = calendar;
        }
        if (data.has("temporary")) {
            this.temporary = data.getBoolean("temporary");
        }
        if (data.has("uses")) {
            this.uses = data.getInt("uses");
        }
        if (data.has("max_uses")) {
            this.maxUses = data.getInt("max_uses");
            if (this.maxUses == 0) {
                this.maxUses = -1;
            }
        }
        if (data.has("inviter")) {
            this.creator = api.getOrCreateUser(data.getJSONObject("inviter"));
        }
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public URL getInviteUrl() {
        try {
            return new URL("https://discord.gg/" + this.code);
        }
        catch (MalformedURLException e) {
            logger.warn("Malformed invite url of invite code {}! Please contact the developer!", (Object)this.code, (Object)e);
            return null;
        }
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public Server getServer() {
        return this.api.getServerById(this.serverId);
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public Channel getChannel() {
        Server server = this.getServer();
        return server == null ? null : server.getChannelById(this.channelId);
    }

    @Override
    public VoiceChannel getVoiceChannel() {
        Server server = this.getServer();
        return server == null ? null : server.getVoiceChannelById(this.channelId);
    }

    @Override
    public boolean isVoiceChannel() {
        return this.voice;
    }

    @Override
    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public boolean isRevoked() {
        return this.revoked;
    }

    @Override
    public Calendar getCreationDate() {
        if (this.creationDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.creationDate.getTime());
        return calendar;
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    @Override
    public int getMaxUses() {
        return this.maxUses;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public User getCreator() {
        return this.creator;
    }

    @Override
    public Future<Server> acceptInvite() {
        return this.acceptInvite(null);
    }

    @Override
    public Future<Server> acceptInvite(FutureCallback<Server> callback) {
        return this.api.acceptInvite(this.getCode(), callback);
    }

    @Override
    public Future<Void> delete() {
        return this.api.deleteInvite(this.getCode());
    }

    public String toString() {
        return this.getCode();
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }
}

