/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.impl;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.InviteBuilder;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplInviteBuilder;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.MessageHistory;
import de.btobastian.javacord.entities.message.embed.EmbedBuilder;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.entities.message.impl.ImplMessageHistory;
import de.btobastian.javacord.entities.permissions.Permissions;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplPermissions;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.channel.ChannelChangeNameListener;
import de.btobastian.javacord.listener.channel.ChannelChangePositionListener;
import de.btobastian.javacord.listener.channel.ChannelChangeTopicListener;
import de.btobastian.javacord.listener.channel.ChannelDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.SnowflakeUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.io.File;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplChannel
implements Channel {
    private static final Logger logger = LoggerUtil.getLogger(ImplChannel.class);
    private static final Permissions emptyPermissions = new ImplPermissions(0, 0);
    private final ImplDiscordAPI api;
    private final String id;
    private String name;
    private String topic = null;
    private String parentId = null;
    private int position;
    private final ImplServer server;
    private final ConcurrentHashMap<String, Permissions> overwrittenPermissions = new ConcurrentHashMap();

    public ImplChannel(JSONObject data, ImplServer server, ImplDiscordAPI api) {
        this.api = api;
        this.server = server;
        this.id = data.getString("id");
        this.name = data.getString("name");
        try {
            this.topic = data.getString("topic");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.position = data.getInt("position");
        if (data.has("parent_id") && !data.isNull("parent_id")) {
            this.parentId = data.getString("parent_id");
        }
        JSONArray permissionOverwrites = data.getJSONArray("permission_overwrites");
        for (int i = 0; i < permissionOverwrites.length(); ++i) {
            Role role;
            JSONObject permissionOverwrite = permissionOverwrites.getJSONObject(i);
            String id = permissionOverwrite.getString("id");
            int allow = permissionOverwrite.getInt("allow");
            int deny = permissionOverwrite.getInt("deny");
            String type = permissionOverwrite.getString("type");
            if (type.equals("role") && (role = server.getRoleById(id)) != null) {
                ((ImplRole)role).setOverwrittenPermissions(this, (Permissions)new ImplPermissions(allow, deny));
            }
            if (!type.equals("member")) continue;
            this.overwrittenPermissions.put(id, new ImplPermissions(allow, deny));
        }
        server.addChannel(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Calendar getCreationDate() {
        return SnowflakeUtil.parseDate(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public Future<Void> delete() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete channel {}", (Object)ImplChannel.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplChannel.this.id).header("authorization", ImplChannel.this.api.getToken()).asJson();
                ImplChannel.this.api.checkResponse(response);
                ImplChannel.this.server.removeChannel(ImplChannel.this);
                logger.info("Deleted channel {}", (Object)ImplChannel.this);
                ImplChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<ChannelDeleteListener> listeners;
                        List<ChannelDeleteListener> list = listeners = ImplChannel.this.api.getListeners(ChannelDeleteListener.class);
                        synchronized (list) {
                            for (ChannelDeleteListener listener : listeners) {
                                listener.onChannelDelete(ImplChannel.this.api, ImplChannel.this);
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public void type() {
        try {
            logger.debug("Sending typing state in channel {}", (Object)this);
            Unirest.post("https://discordapp.com/api/v6/channels/" + this.id + "/typing").header("authorization", this.api.getToken()).asJson();
            logger.debug("Sent typing state in channel {}", (Object)this);
        }
        catch (UnirestException e) {
            logger.warn("Couldn't send typing state in channel {}. Please contact the developer!", (Object)this, (Object)e);
        }
    }

    @Override
    public InviteBuilder getInviteBuilder() {
        return new ImplInviteBuilder(this, this.api);
    }

    @Override
    public Future<Message> sendMessage(String content) {
        return this.sendMessage(content, null, false, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, String nonce) {
        return this.sendMessage(content, null, false, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts) {
        return this.sendMessage(content, null, tts, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts, String nonce) {
        return this.sendMessage(content, null, tts, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed) {
        return this.sendMessage(content, embed, false, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, String nonce) {
        return this.sendMessage(content, embed, false, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, boolean tts) {
        return this.sendMessage(content, embed, tts, null, null);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, String nonce) {
        return this.sendMessage(content, embed, tts, nonce, null);
    }

    @Override
    public Future<Message> sendMessage(String content, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, false, null, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, String nonce, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, false, nonce, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, tts, null, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, boolean tts, String nonce, FutureCallback<Message> callback) {
        return this.sendMessage(content, null, tts, nonce, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, FutureCallback<Message> callback) {
        return this.sendMessage(content, embed, false, null, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, String nonce, FutureCallback<Message> callback) {
        return this.sendMessage(content, embed, false, nonce, callback);
    }

    @Override
    public Future<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, FutureCallback<Message> callback) {
        return this.sendMessage(content, embed, tts, null, callback);
    }

    @Override
    public Future<Message> sendMessage(final String content, final EmbedBuilder embed, final boolean tts, final String nonce, FutureCallback<Message> callback) {
        final ImplChannel receiver = this;
        ListenableFuture<Message> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                logger.debug("Trying to send message in channel {} (content: \"{}\", tts: {})", ImplChannel.this, content, tts);
                ImplChannel.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                JSONObject body = new JSONObject().put("content", content).put("tts", tts).put("mentions", new String[0]);
                if (embed != null) {
                    body.put("embed", embed.toJSONObject());
                }
                if (nonce != null) {
                    body.put("nonce", nonce);
                }
                HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplChannel.this.id + "/messages").header("authorization", ImplChannel.this.api.getToken()).header("content-type", "application/json").body(body.toString()).asJson();
                ImplChannel.this.api.checkResponse(response);
                ImplChannel.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                logger.debug("Sent message in channel {} (content: \"{}\", tts: {})", ImplChannel.this, content, tts);
                return new ImplMessage(response.getBody().getObject(), ImplChannel.this.api, receiver);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Message> sendFile(File file) {
        return this.sendFile(file, null, null);
    }

    @Override
    public Future<Message> sendFile(File file, FutureCallback<Message> callback) {
        return this.sendFile(file, null, callback);
    }

    @Override
    public Future<Message> sendFile(InputStream inputStream, String filename) {
        return this.sendFile(inputStream, filename, null, null);
    }

    @Override
    public Future<Message> sendFile(InputStream inputStream, String filename, FutureCallback<Message> callback) {
        return this.sendFile(inputStream, filename, null, callback);
    }

    @Override
    public Future<Message> sendFile(File file, String comment) {
        return this.sendFile(file, comment, null);
    }

    @Override
    public Future<Message> sendFile(final File file, final String comment, FutureCallback<Message> callback) {
        final ImplChannel receiver = this;
        ListenableFuture<Message> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                logger.debug("Trying to send a file in channel {} (name: {}, comment: {})", ImplChannel.this, file.getName(), comment);
                ImplChannel.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                MultipartBody body = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplChannel.this.id + "/messages").header("authorization", ImplChannel.this.api.getToken()).field("file", file);
                if (comment != null) {
                    body.field("content", comment);
                }
                HttpResponse<JsonNode> response = body.asJson();
                ImplChannel.this.api.checkResponse(response);
                ImplChannel.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                logger.debug("Sent a file in channel {} (name: {}, comment: {})", ImplChannel.this, file.getName(), comment);
                return new ImplMessage(response.getBody().getObject(), ImplChannel.this.api, receiver);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Message> sendFile(InputStream inputStream, String filename, String comment) {
        return this.sendFile(inputStream, filename, comment, null);
    }

    @Override
    public Future<Message> sendFile(final InputStream inputStream, final String filename, final String comment, FutureCallback<Message> callback) {
        final ImplChannel receiver = this;
        ListenableFuture<Message> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            @Override
            public Message call() throws Exception {
                logger.debug("Trying to send an input stream in channel {} (comment: {})", (Object)ImplChannel.this, (Object)comment);
                ImplChannel.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                MultipartBody body = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplChannel.this.id + "/messages").header("authorization", ImplChannel.this.api.getToken()).field("file", inputStream, filename);
                if (comment != null) {
                    body.field("content", comment);
                }
                HttpResponse<JsonNode> response = body.asJson();
                ImplChannel.this.api.checkResponse(response);
                ImplChannel.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                logger.debug("Sent an input stream in channel {} (comment: {})", (Object)ImplChannel.this, (Object)comment);
                return new ImplMessage(response.getBody().getObject(), ImplChannel.this.api, receiver);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Permissions getOverwrittenPermissions(User user) {
        Permissions permissions = this.overwrittenPermissions.get(user.getId());
        return permissions == null ? emptyPermissions : permissions;
    }

    @Override
    public Permissions getOverwrittenPermissions(Role role) {
        return role.getOverwrittenPermissions(this);
    }

    @Override
    public Future<Void> updateOverwrittenPermissions(final Role role, final Permissions permissions) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Updating permissions in channel {} for role {} (allow: {}, deny: {})", this, role, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                Unirest.put("https://discordapp.com/api/v6/channels/" + ImplChannel.this.getId() + "/permissions/" + role.getId()).header("authorization", ImplChannel.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("allow", ((ImplPermissions)permissions).getAllowed()).put("deny", ((ImplPermissions)permissions).getDenied()).put("type", "role").toString()).asJson();
                logger.debug("Updated permissions in channel {} for role {} (allow: {}, deny: {})", this, role, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateOverwrittenPermissions(final User user, final Permissions permissions) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Updating permissions in channel {} for user {} (allow: {}, deny: {})", this, user, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                Unirest.put("https://discordapp.com/api/v6/channels/" + ImplChannel.this.getId() + "/permissions/" + user.getId()).header("authorization", ImplChannel.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("allow", ((ImplPermissions)permissions).getAllowed()).put("deny", ((ImplPermissions)permissions).getDenied()).put("type", "member").toString()).asJson();
                logger.debug("Updated permissions in channel {} for user {} (allow: {}, deny: {})", this, user, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteOverwrittenPermissions(final Role role) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Deleting permissions in channel {} for role {}", (Object)this, (Object)role);
                Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplChannel.this.getId() + "/permissions/" + role.getId()).header("authorization", ImplChannel.this.api.getToken()).asJson();
                logger.debug("Deleted permissions in channel {} for role {}", (Object)this, (Object)role);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteOverwrittenPermissions(final User user) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Deleting permissions in channel {} for user {}", (Object)this, (Object)user);
                Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplChannel.this.getId() + "/permissions/" + user.getId()).header("authorization", ImplChannel.this.api.getToken()).asJson();
                logger.debug("Deleted permissions in channel {} for user {}", (Object)this, (Object)user);
                return null;
            }
        });
    }

    @Override
    public Future<MessageHistory> getMessageHistory(int limit) {
        return this.getMessageHistory(null, false, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistory(int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(null, false, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(Message before, int limit) {
        return this.getMessageHistory(before.getId(), true, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(Message before, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(before.getId(), true, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(String beforeId, int limit) {
        return this.getMessageHistory(beforeId, true, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryBefore(String beforeId, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(beforeId, true, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(Message after, int limit) {
        return this.getMessageHistory(after.getId(), false, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(Message after, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(after.getId(), false, limit, callback);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(String afterId, int limit) {
        return this.getMessageHistory(afterId, false, limit, null);
    }

    @Override
    public Future<MessageHistory> getMessageHistoryAfter(String afterId, int limit, FutureCallback<MessageHistory> callback) {
        return this.getMessageHistory(afterId, false, limit, callback);
    }

    @Override
    public Future<Void> updateName(String newName) {
        return this.update(newName, this.getTopic(), this.getPosition());
    }

    @Override
    public Future<Void> updateTopic(String newTopic) {
        return this.update(this.getName(), newTopic, this.getPosition());
    }

    @Override
    public Future<Void> updatePosition(int newPosition) {
        return this.update(this.getName(), this.getTopic(), newPosition);
    }

    @Override
    public Future<Void> update(final String newName, final String newTopic, final int newPosition) {
        final JSONObject params = new JSONObject().put("name", newName).put("topic", newTopic).put("position", newPosition);
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to update channel {} (new name: {}, old name: {}, new topic: {}, old topic: {}, new position: {}, old position: {})", ImplChannel.this, newName, ImplChannel.this.getName(), newTopic, ImplChannel.this.getTopic(), newPosition, ImplChannel.this.getPosition());
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/channels/" + ImplChannel.this.getId()).header("authorization", ImplChannel.this.api.getToken()).header("Content-Type", "application/json").body(params.toString()).asJson();
                ImplChannel.this.api.checkResponse(response);
                ImplChannel.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplChannel.this.server, null);
                logger.info("Updated channel {} (new name: {}, old name: {}, new topic: {}, old topic: {}, new position: {}, old position: {})", ImplChannel.this, newName, ImplChannel.this.getName(), newTopic, ImplChannel.this.getTopic(), newPosition, ImplChannel.this.getPosition());
                String updatedName = response.getBody().getObject().getString("name");
                String updatedTopic = null;
                if (response.getBody().getObject().has("topic") && !response.getBody().getObject().isNull("topic")) {
                    updatedTopic = response.getBody().getObject().getString("topic");
                }
                int updatedPosition = response.getBody().getObject().getInt("position");
                if (!updatedName.equals(ImplChannel.this.getName())) {
                    final String oldName = ImplChannel.this.getName();
                    ImplChannel.this.setName(updatedName);
                    ImplChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<ChannelChangeNameListener> listeners;
                            List<ChannelChangeNameListener> list = listeners = ImplChannel.this.api.getListeners(ChannelChangeNameListener.class);
                            synchronized (list) {
                                for (ChannelChangeNameListener listener : listeners) {
                                    try {
                                        listener.onChannelChangeName(ImplChannel.this.api, ImplChannel.this, oldName);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in ChannelChangeNameListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (ImplChannel.this.getTopic() != null && updatedTopic == null || ImplChannel.this.getTopic() == null && updatedTopic != null || ImplChannel.this.getTopic() != null && !ImplChannel.this.getTopic().equals(updatedTopic)) {
                    final String oldTopic = ImplChannel.this.getTopic();
                    ImplChannel.this.setTopic(updatedTopic);
                    ImplChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<ChannelChangeTopicListener> listeners;
                            List<ChannelChangeTopicListener> list = listeners = ImplChannel.this.api.getListeners(ChannelChangeTopicListener.class);
                            synchronized (list) {
                                for (ChannelChangeTopicListener listener : listeners) {
                                    try {
                                        listener.onChannelChangeTopic(ImplChannel.this.api, ImplChannel.this, oldTopic);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in ChannelChangeTopicListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (updatedPosition != ImplChannel.this.getPosition()) {
                    final int oldPosition = ImplChannel.this.getPosition();
                    ImplChannel.this.setPosition(updatedPosition);
                    ImplChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<ChannelChangePositionListener> listeners;
                            List<ChannelChangePositionListener> list = listeners = ImplChannel.this.api.getListeners(ChannelChangePositionListener.class);
                            synchronized (list) {
                                for (ChannelChangePositionListener listener : listeners) {
                                    try {
                                        listener.onChannelChangePosition(ImplChannel.this.api, ImplChannel.this, oldPosition);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in ChannelChangePositionListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public String getMentionTag() {
        return "<#" + this.getId() + ">";
    }

    @Override
    public Future<Void> bulkDelete(final String ... messages) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Bulk deleting messages in channel {} (ids: [{}])", (Object)this, (Object)Joiner.on(",").join(messages));
                ImplChannel.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/channels/" + ImplChannel.this.getId() + "/messages/bulk-delete").header("authorization", ImplChannel.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("messages", messages).toString()).asJson();
                ImplChannel.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE, null, ImplChannel.this);
                logger.debug("Bulk deleted messages in channel {} (ids: [{}])", (Object)this, (Object)Joiner.on(",").join(messages));
                return null;
            }
        });
    }

    @Override
    public Future<Void> bulkDelete(Message ... messages) {
        String[] messageIds = new String[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            messageIds[i] = messages[i].getId();
        }
        return this.bulkDelete(messageIds);
    }

    @Override
    public Future<Message> getMessageById(final String messageId) {
        Message message = this.api.getMessageById(messageId);
        if (message != null) {
            return Futures.immediateFuture(message);
        }
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Message>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Message call() throws Exception {
                Message message;
                logger.debug("Requesting message (channel id: {}, message id: {})", (Object)ImplChannel.this.id, (Object)messageId);
                HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/channels/" + ImplChannel.this.id + "/messages/" + messageId).header("authorization", ImplChannel.this.api.getToken()).asJson();
                ImplChannel.this.api.checkResponse(response);
                ImplChannel.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, ImplChannel.this);
                ImplDiscordAPI implDiscordAPI = ImplChannel.this.api;
                synchronized (implDiscordAPI) {
                    message = ImplChannel.this.api.getMessageById(messageId);
                    if (message == null) {
                        message = new ImplMessage(response.getBody().getObject(), ImplChannel.this.api, ImplChannel.this);
                    }
                    logger.debug("Got message (channel id: {}, message id: {}, message: {})", ImplChannel.this.id, messageId, message);
                }
                return message;
            }
        });
    }

    private Future<MessageHistory> getMessageHistory(final String messageId, final boolean before, final int limit, FutureCallback<MessageHistory> callback) {
        ListenableFuture<MessageHistory> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<MessageHistory>(){

            @Override
            public MessageHistory call() throws Exception {
                ImplMessageHistory history = new ImplMessageHistory(ImplChannel.this.api, ImplChannel.this.id, messageId, before, limit);
                ImplChannel.this.api.addHistory(history);
                return history;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setOverwrittenPermissions(User user, Permissions permissions) {
        this.overwrittenPermissions.put(user.getId(), permissions);
    }

    public void removeOverwrittenPermissions(User user) {
        this.overwrittenPermissions.remove(user.getId());
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

