/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord;

import com.google.common.io.BaseEncoding;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import de.btobastian.javacord.DiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Invite;
import de.btobastian.javacord.entities.Region;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.impl.ImplInvite;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.impl.ImplUser;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.MessageHistory;
import de.btobastian.javacord.entities.message.impl.ImplMessageHistory;
import de.btobastian.javacord.entities.permissions.Permissions;
import de.btobastian.javacord.entities.permissions.PermissionsBuilder;
import de.btobastian.javacord.entities.permissions.impl.ImplPermissionsBuilder;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.exceptions.BadResponseException;
import de.btobastian.javacord.exceptions.NotSupportedForBotsException;
import de.btobastian.javacord.exceptions.PermissionsException;
import de.btobastian.javacord.exceptions.RateLimitedException;
import de.btobastian.javacord.listener.Listener;
import de.btobastian.javacord.listener.server.ServerJoinListener;
import de.btobastian.javacord.listener.user.UserChangeNameListener;
import de.btobastian.javacord.utils.DiscordWebsocketAdapter;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.ThreadPool;
import de.btobastian.javacord.utils.ratelimits.RateLimitManager;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplDiscordAPI
implements DiscordAPI {
    private static final Logger logger = LoggerUtil.getLogger(ImplDiscordAPI.class);
    private final ThreadPool pool;
    private String email = null;
    private String password = null;
    private String token = null;
    private String game = null;
    private String streamingUrl = null;
    private boolean idle = false;
    private boolean autoReconnect = true;
    private boolean waitForServersOnStartup = true;
    private boolean lazyLoading = false;
    private User you = null;
    private volatile int messageCacheSize = 200;
    private DiscordWebsocketAdapter socketAdapter = null;
    private RateLimitManager rateLimitManager = new RateLimitManager();
    private final ConcurrentHashMap<String, Server> servers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, User> users = new ConcurrentHashMap();
    private final ArrayList<Message> messages = new ArrayList();
    private final ConcurrentHashMap<Class<?>, List<Listener>> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, SettableFuture<Server>> waitingForListener = new ConcurrentHashMap();
    private final Set<MessageHistory> messageHistories = Collections.newSetFromMap(new WeakHashMap());
    private final Object listenerLock = new Object();
    private final ServerJoinListener listener = new ServerJoinListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServerJoin(DiscordAPI api, Server server) {
            Object object = ImplDiscordAPI.this.listenerLock;
            synchronized (object) {
                SettableFuture future = (SettableFuture)ImplDiscordAPI.this.waitingForListener.get(server.getId());
                if (future != null) {
                    logger.debug("Joined or created server {}. We were waiting for this server!", (Object)server);
                    ImplDiscordAPI.this.waitingForListener.remove(server.getId());
                    future.set(server);
                }
            }
        }
    };
    private final Set<String> unavailableServers = new HashSet<String>();

    public ImplDiscordAPI(ThreadPool pool) {
        this.pool = pool;
    }

    @Override
    public void connect(FutureCallback<DiscordAPI> callback) {
        final ImplDiscordAPI api = this;
        Futures.addCallback(this.pool.getListeningExecutorService().submit(new Callable<DiscordAPI>(){

            @Override
            public DiscordAPI call() throws Exception {
                ImplDiscordAPI.this.connectBlocking();
                return api;
            }
        }), callback);
    }

    @Override
    public void connectBlocking() {
        if (this.token == null || !this.checkTokenBlocking(this.token)) {
            if (this.email == null || this.password == null) {
                throw new IllegalArgumentException("No valid token provided AND missing email or password. Connecting not possible!");
            }
            this.token = this.requestTokenBlocking();
        }
        String gateway = this.requestGatewayBlocking();
        this.socketAdapter = new DiscordWebsocketAdapter(this, gateway);
        try {
            if (!this.socketAdapter.isReady().get().booleanValue()) {
                throw new IllegalStateException("Socket closed before ready packet was received!");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Something went wrong while connecting. Please contact the developer!", e);
            throw new IllegalStateException("Could not figure out if ready or not. Please contact the developer!");
        }
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setGame(String game) {
        this.setGame(game, null);
    }

    @Override
    public void setGame(String game, String streamingUrl) {
        this.game = game;
        this.streamingUrl = streamingUrl;
        try {
            if (this.socketAdapter != null && this.socketAdapter.isReady().isDone() && this.socketAdapter.isReady().get().booleanValue()) {
                this.socketAdapter.updateStatus();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String getStreamingUrl() {
        return this.streamingUrl;
    }

    @Override
    public Server getServerById(String id) {
        return this.servers.get(id);
    }

    @Override
    public Collection<Server> getServers() {
        return Collections.unmodifiableCollection(this.servers.values());
    }

    @Override
    public Collection<Channel> getChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (Server server : this.getServers()) {
            channels.addAll(server.getChannels());
        }
        return Collections.unmodifiableCollection(channels);
    }

    @Override
    public Channel getChannelById(String id) {
        Iterator<Server> serverIterator = this.getServers().iterator();
        while (serverIterator.hasNext()) {
            Channel channel = serverIterator.next().getChannelById(id);
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    @Override
    public Collection<VoiceChannel> getVoiceChannels() {
        ArrayList<VoiceChannel> channels = new ArrayList<VoiceChannel>();
        for (Server server : this.getServers()) {
            channels.addAll(server.getVoiceChannels());
        }
        return Collections.unmodifiableCollection(channels);
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        Iterator<Server> serverIterator = this.getServers().iterator();
        while (serverIterator.hasNext()) {
            VoiceChannel channel = serverIterator.next().getVoiceChannelById(id);
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    @Override
    public Future<User> getUserById(final String id) {
        User user = this.users.get(id);
        if (user != null) {
            return Futures.immediateFuture(user);
        }
        return this.getThreadPool().getListeningExecutorService().submit(new Callable<User>(){

            @Override
            public User call() throws Exception {
                logger.debug("Trying request/find user with id {} who isn't cached", (Object)id);
                User user = null;
                for (Server server : ImplDiscordAPI.this.getServers()) {
                    HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/guilds/" + server.getId() + "/members/" + id).header("authorization", ImplDiscordAPI.this.token).asJson();
                    if (response.getStatus() < 200 || response.getStatus() > 299) continue;
                    user = ImplDiscordAPI.this.getOrCreateUser(response.getBody().getObject().getJSONObject("user"));
                    ((ImplServer)server).addMember(user);
                    if (!response.getBody().getObject().has("roles")) continue;
                    JSONArray roleIds = response.getBody().getObject().getJSONArray("roles");
                    for (int i = 0; i < roleIds.length(); ++i) {
                        ((ImplRole)server.getRoleById(roleIds.getString(i))).addUserNoUpdate(user);
                    }
                }
                if (user != null) {
                    logger.debug("Found user {} with id {}", (Object)user, (Object)id);
                } else {
                    logger.debug("No user with id {} was found", (Object)id);
                }
                return user;
            }
        });
    }

    @Override
    public User getCachedUserById(String id) {
        return this.users.get(id);
    }

    @Override
    public Collection<User> getUsers() {
        return Collections.unmodifiableCollection(this.users.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(Listener listener) {
        for (Class clazz : TypeToken.of(listener.getClass()).getTypes().interfaces().rawTypes()) {
            if (!Listener.class.isAssignableFrom(clazz)) continue;
            List<Listener> listenersList = this.listeners.get(clazz);
            if (listenersList == null) {
                listenersList = new ArrayList<Listener>();
                this.listeners.put(clazz, listenersList);
            }
            List<Listener> list = listenersList;
            synchronized (list) {
                listenersList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessageById(String id) {
        Collection<Object> collection = this.messages;
        synchronized (collection) {
            for (Message message : this.messages) {
                if (!message.getId().equals(id)) continue;
                return message;
            }
        }
        collection = this.messageHistories;
        synchronized (collection) {
            for (MessageHistory history : this.messageHistories) {
                history.getMessageById(id);
            }
        }
        return null;
    }

    @Override
    public ThreadPool getThreadPool() {
        return this.pool;
    }

    @Override
    public void setIdle(boolean idle) {
        this.idle = idle;
        try {
            if (this.socketAdapter != null && this.socketAdapter.isReady().isDone() && this.socketAdapter.isReady().get().booleanValue()) {
                this.socketAdapter.updateStatus();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isIdle() {
        return this.idle;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token, boolean bot) {
        this.token = bot ? "Bot " + token : token;
    }

    @Override
    public boolean checkTokenBlocking(String token) {
        try {
            logger.debug("Checking token {}", (Object)token.replaceAll(".{10}", "**********"));
            HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/users/@me/guilds").header("authorization", token).asJson();
            if (response.getStatus() < 200 || response.getStatus() > 299) {
                logger.debug("Checked token {} (valid: {})", (Object)token.replaceAll(".{10}", "**********"), (Object)false);
                return false;
            }
            logger.debug("Checked token {} (valid: {})", (Object)token.replaceAll(".{10}", "**********"), (Object)true);
            return true;
        }
        catch (UnirestException e) {
            return false;
        }
    }

    @Override
    public Future<Server> acceptInvite(String inviteCode) {
        return this.acceptInvite(inviteCode, null);
    }

    @Override
    public Future<Server> acceptInvite(final String inviteCode, FutureCallback<Server> callback) {
        if (this.getYourself().isBot()) {
            throw new NotSupportedForBotsException();
        }
        ListenableFuture<Server> future = this.getThreadPool().getListeningExecutorService().submit(new Callable<Server>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Server call() throws Exception {
                SettableFuture settableFuture;
                logger.debug("Trying to accept invite (code: {})", (Object)inviteCode);
                Object object = ImplDiscordAPI.this.listenerLock;
                synchronized (object) {
                    HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/invite/" + inviteCode).header("authorization", ImplDiscordAPI.this.token).asJson();
                    ImplDiscordAPI.this.checkResponse(response);
                    String guildId = response.getBody().getObject().getJSONObject("guild").getString("id");
                    if (ImplDiscordAPI.this.getServerById(guildId) != null) {
                        throw new IllegalStateException("Already member of this server!");
                    }
                    logger.info("Accepted invite and waiting for listener to be called (code: {}, server id: {})", (Object)inviteCode, (Object)guildId);
                    settableFuture = SettableFuture.create();
                    ImplDiscordAPI.this.waitingForListener.put(guildId, settableFuture);
                }
                return (Server)settableFuture.get();
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Server> createServer(String name) {
        return this.createServer(name, Region.US_WEST, null, null);
    }

    @Override
    public Future<Server> createServer(String name, FutureCallback<Server> callback) {
        return this.createServer(name, Region.US_WEST, null, callback);
    }

    @Override
    public Future<Server> createServer(String name, Region region) {
        return this.createServer(name, region, null, null);
    }

    @Override
    public Future<Server> createServer(String name, Region region, FutureCallback<Server> callback) {
        return this.createServer(name, region, null, callback);
    }

    @Override
    public Future<Server> createServer(String name, BufferedImage icon) {
        return this.createServer(name, Region.US_WEST, icon, null);
    }

    @Override
    public Future<Server> createServer(String name, BufferedImage icon, FutureCallback<Server> callback) {
        return this.createServer(name, Region.US_WEST, icon, callback);
    }

    @Override
    public Future<Server> createServer(String name, Region region, BufferedImage icon) {
        return this.createServer(name, region, icon, null);
    }

    @Override
    public Future<Server> createServer(final String name, final Region region, final BufferedImage icon, FutureCallback<Server> callback) {
        ListenableFuture<Server> future = this.getThreadPool().getListeningExecutorService().submit(new Callable<Server>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Server call() throws Exception {
                SettableFuture settableFuture;
                logger.debug("Trying to create server (name: {}, region: {}, icon: {}", name, region == null ? "null" : region.getKey(), icon != null);
                if (name == null || name.length() < 2 || name.length() > 100) {
                    throw new IllegalArgumentException("Name must be 2-100 characters long!");
                }
                JSONObject params = new JSONObject();
                if (icon != null) {
                    if (icon.getHeight() != 128 || icon.getWidth() != 128) {
                        throw new IllegalArgumentException("Icon must be 128*128px!");
                    }
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)icon, "jpg", os);
                    params.put("icon", "data:image/jpg;base64," + BaseEncoding.base64().encode(os.toByteArray()));
                }
                params.put("name", name);
                params.put("region", region == null ? Region.US_WEST.getKey() : region.getKey());
                Object object = ImplDiscordAPI.this.listenerLock;
                synchronized (object) {
                    HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/guilds").header("authorization", ImplDiscordAPI.this.token).header("Content-Type", "application/json").body(params.toString()).asJson();
                    ImplDiscordAPI.this.checkResponse(response);
                    String guildId = response.getBody().getObject().getString("id");
                    logger.info("Created server and waiting for listener to be called (name: {}, region: {}, icon: {}, server id: {})", name, region == null ? "null" : region.getKey(), icon != null, guildId);
                    settableFuture = SettableFuture.create();
                    ImplDiscordAPI.this.waitingForListener.put(guildId, settableFuture);
                }
                return (Server)settableFuture.get();
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public User getYourself() {
        return this.you;
    }

    @Override
    public Future<Void> updateUsername(String newUsername) {
        return this.updateProfile(newUsername, null, null, null);
    }

    @Override
    public Future<Void> updateEmail(String newEmail) {
        return this.updateProfile(null, newEmail, null, null);
    }

    @Override
    public Future<Void> updatePassword(String newPassword) {
        return this.updateProfile(null, null, newPassword, null);
    }

    @Override
    public Future<Void> updateAvatar(BufferedImage newAvatar) {
        return this.updateProfile(null, null, null, newAvatar);
    }

    @Override
    public Future<Void> updateProfile(final String newUsername, String newEmail, final String newPassword, final BufferedImage newAvatar) {
        logger.debug("Trying to update profile (username: {}, email: {}, password: {}, change avatar: {}", newUsername, this.email, newPassword == null ? "null" : newPassword.replaceAll(".", "*"), newAvatar != null);
        String avatarString = this.getYourself().getAvatarId();
        if (newAvatar != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)newAvatar, "jpg", os);
                avatarString = "data:image/jpg;base64," + BaseEncoding.base64().encode(os.toByteArray());
            }
            catch (IOException os) {
                // empty catch block
            }
        }
        final JSONObject params = new JSONObject().put("username", newUsername == null ? this.getYourself().getName() : newUsername).put("avatar", avatarString == null ? JSONObject.NULL : avatarString);
        if (this.email != null && this.password != null) {
            params.put("email", newEmail == null ? this.email : newEmail).put("password", this.password);
        }
        if (newPassword != null) {
            params.put("new_password", newPassword);
        }
        return this.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/users/@me").header("authorization", ImplDiscordAPI.this.token).header("Content-Type", "application/json").body(params.toString()).asJson();
                ImplDiscordAPI.this.checkResponse(response);
                logger.info("Updated profile (username: {}, email: {}, password: {}, change avatar: {}", newUsername, ImplDiscordAPI.this.email, newPassword == null ? "null" : newPassword.replaceAll(".", "*"), newAvatar != null);
                ((ImplUser)ImplDiscordAPI.this.getYourself()).setAvatarId(response.getBody().getObject().getString("avatar"));
                if (response.getBody().getObject().has("email") && !response.getBody().getObject().isNull("email")) {
                    ImplDiscordAPI.this.setEmail(response.getBody().getObject().getString("email"));
                }
                ImplDiscordAPI.this.setToken(response.getBody().getObject().getString("token"), ImplDiscordAPI.this.token.startsWith("Bot "));
                final String oldName = ImplDiscordAPI.this.getYourself().getName();
                ((ImplUser)ImplDiscordAPI.this.getYourself()).setName(response.getBody().getObject().getString("username"));
                if (newPassword != null) {
                    ImplDiscordAPI.this.password = newPassword;
                }
                if (!ImplDiscordAPI.this.getYourself().getName().equals(oldName)) {
                    ImplDiscordAPI.this.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<UserChangeNameListener> listeners;
                            List<UserChangeNameListener> list = listeners = ImplDiscordAPI.this.getListeners(UserChangeNameListener.class);
                            synchronized (list) {
                                for (UserChangeNameListener listener : listeners) {
                                    listener.onUserChangeName(ImplDiscordAPI.this, ImplDiscordAPI.this.getYourself(), oldName);
                                }
                            }
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public Future<Invite> parseInvite(String invite) {
        return this.parseInvite(invite, null);
    }

    @Override
    public Future<Invite> parseInvite(final String invite, FutureCallback<Invite> callback) {
        final String inviteCode = invite.replace("https://discord.gg/", "").replace("http://discord.gg/", "");
        ListenableFuture<Invite> future = this.getThreadPool().getListeningExecutorService().submit(new Callable<Invite>(){

            @Override
            public Invite call() throws Exception {
                logger.debug("Trying to parse invite {} (parsed code: {})", (Object)invite, (Object)inviteCode);
                HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/invite/" + inviteCode).header("authorization", ImplDiscordAPI.this.token).asJson();
                ImplDiscordAPI.this.checkResponse(response);
                logger.debug("Parsed invite {} (parsed code: {})", (Object)invite, (Object)inviteCode);
                return new ImplInvite(ImplDiscordAPI.this, response.getBody().getObject());
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Void> deleteInvite(final String inviteCode) {
        return this.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete invite {}", (Object)inviteCode);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/invite/" + inviteCode).header("authorization", ImplDiscordAPI.this.token).asJson();
                ImplDiscordAPI.this.checkResponse(response);
                logger.info("Deleted invite {}", (Object)inviteCode);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageCacheSize(int size) {
        this.messageCacheSize = size < 0 ? 0 : size;
        ArrayList<Message> arrayList = this.messages;
        synchronized (arrayList) {
            while (this.messages.size() > this.messageCacheSize) {
                this.messages.remove(0);
            }
        }
    }

    @Override
    public int getMessageCacheSize() {
        return this.messageCacheSize;
    }

    @Override
    public PermissionsBuilder getPermissionsBuilder() {
        return new ImplPermissionsBuilder();
    }

    @Override
    public PermissionsBuilder getPermissionsBuilder(Permissions permissions) {
        return new ImplPermissionsBuilder(permissions);
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @Override
    public boolean isAutoReconnectEnabled() {
        return this.autoReconnect;
    }

    @Override
    public RateLimitManager getRateLimitManager() {
        return this.rateLimitManager;
    }

    @Override
    public void setWaitForServersOnStartup(boolean wait) {
        this.waitForServersOnStartup = wait;
    }

    @Override
    public boolean isWaitingForServersOnStartup() {
        return this.waitForServersOnStartup;
    }

    @Override
    public void disconnect() {
        if (this.socketAdapter != null) {
            this.socketAdapter.disconnect();
        }
    }

    @Override
    public void setReconnectRatelimit(int attempts, int seconds) {
        this.socketAdapter.setReconnectAttempts(attempts);
        this.socketAdapter.setRatelimitResetIntervalInSeconds(seconds);
    }

    @Override
    public void setLazyLoading(boolean enabled) {
        this.lazyLoading = enabled;
    }

    @Override
    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public Set<String> getUnavailableServers() {
        return this.unavailableServers;
    }

    public void setYourself(User user) {
        this.you = user;
    }

    public User getOrCreateUser(JSONObject data) {
        String id = data.getString("id");
        User user = this.users.get(id);
        if (user == null) {
            if (!data.has("username")) {
                return null;
            }
            user = new ImplUser(data, this);
        }
        return user;
    }

    public ConcurrentHashMap<String, Server> getServerMap() {
        return this.servers;
    }

    public ConcurrentHashMap<String, User> getUserMap() {
        return this.users;
    }

    public DiscordWebsocketAdapter getSocketAdapter() {
        return this.socketAdapter;
    }

    public String requestTokenBlocking() {
        try {
            logger.debug("Trying to request token (email: {}, password: {})", (Object)this.email, (Object)this.password.replaceAll(".", "*"));
            HttpResponse<JsonNode> response = Unirest.post("https://discordapp.com/api/v6/auth/login").header("User-Agent", "DiscordBot (https://github.com/BtoBastian/Javacord, v2.0.17)").header("Content-Type", "application/json").body(new JSONObject().put("email", this.email).put("password", this.password).toString()).asJson();
            JSONObject jsonResponse = response.getBody().getObject();
            if (response.getStatus() == 400) {
                throw new IllegalArgumentException("400 Bad request! Maybe wrong email or password? StatusText: " + response.getStatusText() + "; Body: " + response.getBody());
            }
            if (response.getStatus() < 200 || response.getStatus() > 299) {
                throw new IllegalStateException("Received http status code " + response.getStatus() + " with message " + response.getStatusText() + " and body " + response.getBody());
            }
            if (jsonResponse.has("password") || jsonResponse.has("email")) {
                throw new IllegalArgumentException("Wrong email or password!");
            }
            String token = jsonResponse.getString("token");
            logger.debug("Requested token {} (email: {}, password: {})", token.replaceAll(".{10}", "**********"), this.email, this.password.replaceAll(".", "*"));
            return token;
        }
        catch (UnirestException e) {
            logger.warn("Couldn't request token (email: {}, password: {}). Please contact the developer!", this.email, this.password.replaceAll(".", "*"), e);
            return null;
        }
    }

    public String requestGatewayBlocking() {
        try {
            logger.debug("Requesting gateway (token: {})", (Object)this.token.replaceAll(".{10}", "**********"));
            HttpResponse<JsonNode> response = Unirest.get("https://discordapp.com/api/v6/gateway").header("authorization", this.token).asJson();
            if (response.getStatus() == 401) {
                throw new IllegalStateException("Cannot request gateway! Invalid token?");
            }
            if (response.getStatus() < 200 || response.getStatus() > 299) {
                throw new IllegalStateException("Received http status code " + response.getStatus() + " with message " + response.getStatusText() + " and body " + response.getBody());
            }
            String gateway = response.getBody().getObject().getString("url");
            logger.debug("Requested gateway {} (token: {})", (Object)gateway, (Object)this.token.replaceAll(".{10}", "**********"));
            return gateway;
        }
        catch (UnirestException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends Listener> List<T> getListeners(Class<T> listenerClass) {
        ArrayList listenersList = this.listeners.get(listenerClass);
        return listenersList == null ? new ArrayList() : listenersList;
    }

    public <T extends Listener> List<T> getListeners() {
        for (List<Listener> list : this.listeners.values()) {
            try {
                return list;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message) {
        ArrayList<Message> arrayList = this.messages;
        synchronized (arrayList) {
            if (this.messages.size() > this.messageCacheSize) {
                this.messages.remove(0);
            }
            this.messages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(Message message) {
        Collection<Object> collection = this.messages;
        synchronized (collection) {
            this.messages.remove(message);
        }
        collection = this.messageHistories;
        synchronized (collection) {
            for (MessageHistory history : this.messageHistories) {
                ((ImplMessageHistory)history).removeMessage(message.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(MessageHistory history) {
        Set<MessageHistory> set = this.messageHistories;
        synchronized (set) {
            this.messageHistories.add(history);
        }
    }

    public void checkResponse(HttpResponse<JsonNode> response) throws Exception {
        String message = "";
        if (response.getBody() != null && !response.getBody().isArray() && response.getBody().getObject().has("message")) {
            message = " " + response.getBody().getObject().getString("message");
        }
        if (response.getStatus() == 403) {
            throw new PermissionsException("Missing permissions!" + message);
        }
        if (response.getStatus() == 429) {
            return;
        }
        if (response.getStatus() < 200 || response.getStatus() > 299) {
            throw new BadResponseException("Received http status code " + response.getStatus() + " with message " + response.getStatusText() + " and body " + response.getBody(), response.getStatus(), response.getStatusText(), response);
        }
    }

    public void checkRateLimit(HttpResponse<JsonNode> response, RateLimitType type, Server server, Channel channel) throws RateLimitedException {
        if (this.rateLimitManager.isRateLimited(type, server, channel) && type != RateLimitType.UNKNOWN) {
            long retryAfter = this.rateLimitManager.getRateLimit(type, server, channel);
            throw new RateLimitedException("We are rate limited for " + retryAfter + " ms!", retryAfter, type, server, channel, this.rateLimitManager);
        }
        if (response != null && response.getStatus() == 429) {
            long retryAfter = response.getBody().getObject().getLong("retry_after");
            this.rateLimitManager.addRateLimit(type, server, channel, retryAfter);
            throw new RateLimitedException("We are rate limited for " + retryAfter + " ms (type: " + type.name() + ")!", retryAfter, type, server, channel, this.rateLimitManager);
        }
    }

    public Set<MessageHistory> getMessageHistories() {
        return this.messageHistories;
    }

    public ServerJoinListener getInternalServerJoinListener() {
        return this.listener;
    }

    public void setSocketAdapter(DiscordWebsocketAdapter socketAdapter) {
        this.socketAdapter = socketAdapter;
    }
}

