package org.scribe.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class URLUtils {
    private static final String EMPTY_STRING = "";
    private static final Set<EncodingRule> ENCODING_RULES;
    private static final String PAIR_SEPARATOR = "=";
    private static final String PARAM_SEPARATOR = "&";
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String UTF_8 = "UTF-8";
    private static final String ERROR_MSG = String.format("Cannot find specified encoding: %s", UTF_8);

    static {
        Set<EncodingRule> rules = new HashSet<>();
        rules.add(new EncodingRule("*", "%2A"));
        rules.add(new EncodingRule("+", "%20"));
        rules.add(new EncodingRule("%7E", "~"));
        ENCODING_RULES = Collections.unmodifiableSet(rules);
    }

    public static String formURLEncodeMap(Map<String, String> map) {
        Preconditions.checkNotNull(map, "Cannot url-encode a null object");
        return map.size() <= 0 ? EMPTY_STRING : doFormUrlEncode(map);
    }

    private static String doFormUrlEncode(Map<String, String> map) {
        StringBuffer encodedString = new StringBuffer(map.size() * 20);
        for (String key : map.keySet()) {
            encodedString.append(PARAM_SEPARATOR).append(formURLEncode(key));
            if (map.get(key) != null) {
                encodedString.append(PAIR_SEPARATOR).append(formURLEncode(map.get(key)));
            }
        }
        return encodedString.toString().substring(1);
    }

    public static String percentEncode(String string) {
        String encoded = formURLEncode(string);
        for (EncodingRule rule : ENCODING_RULES) {
            encoded = rule.apply(encoded);
        }
        return encoded;
    }

    public static String formURLEncode(String string) {
        Preconditions.checkNotNull(string, "Cannot encode null string");
        try {
            return URLEncoder.encode(string, UTF_8);
        } catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(ERROR_MSG, uee);
        }
    }

    public static String formURLDecode(String string) {
        Preconditions.checkNotNull(string, "Cannot decode null string");
        try {
            return URLDecoder.decode(string, UTF_8);
        } catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(ERROR_MSG, uee);
        }
    }

    public static String appendParametersToQueryString(String url, Map<String, String> params) {
        Preconditions.checkNotNull(url, "Cannot append to null URL");
        String queryString = formURLEncodeMap(params);
        if (!queryString.equals(EMPTY_STRING)) {
            return String.valueOf(String.valueOf(url) + (url.indexOf(63) != -1 ? PARAM_SEPARATOR : Character.valueOf(QUERY_STRING_SEPARATOR))) + queryString;
        }
        return url;
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
    private static final class EncodingRule {
        private final String ch;
        private final String toCh;

        EncodingRule(String ch, String toCh) {
            this.ch = ch;
            this.toCh = toCh;
        }

        String apply(String string) {
            return string.replace(this.ch, this.toCh);
        }
    }
}
