package org.scribe.utils;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class StreamUtils {
    public static String getStreamContents(InputStream is) {
        int read;
        try {
            Preconditions.checkNotNull(is, "Cannot get String from a null object");
            try {
                char[] buffer = new char[65536];
                StringBuilder out = new StringBuilder();
                Reader in = new InputStreamReader(is, "UTF-8");
                do {
                    read = in.read(buffer, 0, buffer.length);
                    if (read > 0) {
                        out.append(buffer, 0, read);
                        continue;
                    }
                } while (read >= 0);
                in.close();
                return out.toString();
            } catch (IOException ioe) {
                throw new IllegalStateException("Error while reading response body", ioe);
            }
        } catch (IllegalArgumentException e) {
            Log.i("Prime31-SU", "InputStream is null when attempting to get it's contents: " + e.getMessage());
            return "";
        }
    }
}
