package org.scribe.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class MapUtils {
    private static final String EMPTY_STRING = "";
    private static final String PAIR_SEPARATOR = "=";
    private static final String PARAM_SEPARATOR = "&";

    public static final Map<String, String> sort(Map<String, String> map) {
        Preconditions.checkNotNull(map, "Cannot sort a null object.");
        Map<String, String> sorted = new LinkedHashMap<>();
        for (String key : getSortedKeys(map)) {
            sorted.put(key, map.get(key));
        }
        return sorted;
    }

    private static List<String> getSortedKeys(Map<String, String> map) {
        List<String> keys = new ArrayList<>(map.keySet());
        Collections.sort(keys);
        return keys;
    }

    public static void decodeAndAppendEntries(Map<String, String> source, Map<String, String> target) {
        for (String key : source.keySet()) {
            target.put(URLUtils.percentEncode(key), URLUtils.percentEncode(source.get(key)));
        }
    }

    public static String concatSortedPercentEncodedParams(Map<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (String key : params.keySet()) {
            result.append(key).append(PAIR_SEPARATOR);
            result.append(params.get(key)).append(PARAM_SEPARATOR);
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        String[] split;
        Map<String, String> result = new HashMap<>();
        if (queryString != null && queryString.length() > 0) {
            for (String param : queryString.split(PARAM_SEPARATOR)) {
                String[] pair = param.split(PAIR_SEPARATOR);
                String key = URLUtils.formURLDecode(pair[0]);
                String value = pair.length > 1 ? URLUtils.formURLDecode(pair[1]) : EMPTY_STRING;
                result.put(key, value);
            }
        }
        return result;
    }
}
