package org.scribe.services;

import java.util.Random;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class TimestampServiceImpl implements TimestampService {
    private Timer timer = new Timer();

    @Override // org.scribe.services.TimestampService
    public String getNonce() {
        Long ts = getTs();
        return String.valueOf(ts.longValue() + this.timer.getRandomInteger().intValue());
    }

    @Override // org.scribe.services.TimestampService
    public String getTimestampInSeconds() {
        return String.valueOf(getTs());
    }

    private Long getTs() {
        return Long.valueOf(this.timer.getMilis().longValue() / 1000);
    }

    void setTimer(Timer timer) {
        this.timer = timer;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
    public static class Timer {
        Timer() {
        }

        Long getMilis() {
            return Long.valueOf(System.currentTimeMillis());
        }

        Integer getRandomInteger() {
            return Integer.valueOf(new Random().nextInt());
        }
    }
}
