package org.scribe.services;

import org.scribe.exceptions.OAuthSignatureException;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class PlaintextSignatureService implements SignatureService {
    private static final String METHOD = "plaintext";

    @Override // org.scribe.services.SignatureService
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return String.valueOf(URLUtils.percentEncode(apiSecret)) + '&' + URLUtils.percentEncode(tokenSecret);
        } catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override // org.scribe.services.SignatureService
    public String getSignatureMethod() {
        return METHOD;
    }
}
