package org.scribe.services;

import com.prime31.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.scribe.exceptions.OAuthSignatureException;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class HMACSha1SignatureService implements SignatureService {
    private static final String CARRIAGE_RETURN = "\r\n";
    private static final String EMPTY_STRING = "";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String METHOD = "HMAC-SHA1";
    private static final String UTF8 = "UTF-8";

    @Override // org.scribe.services.SignatureService
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(baseString, "Base string cant be null or empty string");
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return doSign(baseString, String.valueOf(URLUtils.percentEncode(apiSecret)) + '&' + URLUtils.percentEncode(tokenSecret));
        } catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    private String doSign(String toSign, String keyString) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes(UTF8), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] bytes = mac.doFinal(toSign.getBytes(UTF8));
        return new String(Base64.encodeBytes(bytes)).replace(CARRIAGE_RETURN, EMPTY_STRING);
    }

    @Override // org.scribe.services.SignatureService
    public String getSignatureMethod() {
        return METHOD;
    }
}
