package org.scribe.oauth;

import android.util.Log;
import java.util.Map;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthConstants;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.model.Verifier;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class OAuth10aServiceImpl implements OAuthService {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$scribe$model$SignatureType = null;
    private static final String VERSION = "1.0";
    private DefaultApi10a api;
    private OAuthConfig config;

    static /* synthetic */ int[] $SWITCH_TABLE$org$scribe$model$SignatureType() {
        int[] iArr = $SWITCH_TABLE$org$scribe$model$SignatureType;
        if (iArr == null) {
            iArr = new int[SignatureType.valuesCustom().length];
            try {
                iArr[SignatureType.Header.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                iArr[SignatureType.QueryString.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            $SWITCH_TABLE$org$scribe$model$SignatureType = iArr;
        }
        return iArr;
    }

    public OAuth10aServiceImpl(DefaultApi10a api, OAuthConfig config) {
        this.api = api;
        this.config = config;
    }

    @Override // org.scribe.oauth.OAuthService
    public Token getRequestToken() {
        Log.i("Prime31-OAS", "request token endpoint: " + this.api.getRequestTokenEndpoint());
        OAuthRequest request = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        request.addOAuthParameter(OAuthConstants.CALLBACK, this.config.getCallback());
        addOAuthParams(request, OAuthConstants.EMPTY_TOKEN);
        addSignature(request);
        Response response = request.send();
        try {
            Log.i("Prime31-OAS", "request token response code: " + response.getCode());
            Log.i("Prime31-OAS", "request token body: " + response.getBody());
        } catch (Exception e) {
            Log.i("Prime31-OAS", "error getting request token body: " + e.getMessage());
        }
        return this.api.getRequestTokenExtractor().extract(response.getBody());
    }

    private void addOAuthParams(OAuthRequest request, Token token) {
        request.addOAuthParameter(OAuthConstants.TIMESTAMP, this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter(OAuthConstants.NONCE, this.api.getTimestampService().getNonce());
        request.addOAuthParameter(OAuthConstants.CONSUMER_KEY, this.config.getApiKey());
        request.addOAuthParameter(OAuthConstants.SIGN_METHOD, this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter(OAuthConstants.VERSION, getVersion());
        if (this.config.hasScope()) {
            request.addOAuthParameter(OAuthConstants.SCOPE, this.config.getScope());
        }
        request.addOAuthParameter(OAuthConstants.SIGNATURE, getSignature(request, token));
    }

    @Override // org.scribe.oauth.OAuthService
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        Log.i("Prime31-OAS", "access token endpoint: " + this.api.getAccessTokenEndpoint());
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addOAuthParameter(OAuthConstants.TOKEN, requestToken.getToken());
        request.addOAuthParameter(OAuthConstants.VERIFIER, verifier.getValue());
        addOAuthParams(request, requestToken);
        addSignature(request);
        Response response = request.send();
        try {
            Log.i("Prime31-OAS", "access token response code: " + response.getCode());
            Log.i("Prime31-OAS", "access token body: " + response.getBody());
        } catch (Exception e) {
            Log.i("Prime31-OAS", "error getting access token body: " + e.getMessage());
        }
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    @Override // org.scribe.oauth.OAuthService
    public void signRequest(Token token, OAuthRequest request) {
        request.addOAuthParameter(OAuthConstants.TOKEN, token.getToken());
        addOAuthParams(request, token);
        addSignature(request);
    }

    @Override // org.scribe.oauth.OAuthService
    public String getVersion() {
        return VERSION;
    }

    @Override // org.scribe.oauth.OAuthService
    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(OAuthRequest request, Token token) {
        String baseString = this.api.getBaseStringExtractor().extract(request);
        return this.api.getSignatureService().getSignature(baseString, this.config.getApiSecret(), token.getSecret());
    }

    private void addSignature(OAuthRequest request) {
        switch ($SWITCH_TABLE$org$scribe$model$SignatureType()[this.config.getSignatureType().ordinal()]) {
            case 1:
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader(OAuthConstants.HEADER, oauthHeader);
                return;
            case 2:
                for (Map.Entry<String, String> entry : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter(entry.getKey(), entry.getValue());
                }
                return;
            default:
                return;
        }
    }
}
