package org.scribe.model;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class OAuthRequest extends Request {
    private static final String OAUTH_PREFIX = "oauth_";
    private Map<String, String> oauthParameters;

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void addBodyParameter(String str, String str2) {
        super.addBodyParameter(str, str2);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void addHeader(String str, String str2) {
        super.addHeader(str, str2);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void addPayload(String str) {
        super.addPayload(str);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void addPayload(byte[] bArr) {
        super.addPayload(bArr);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void addQuerystringParameter(String str, String str2) {
        super.addQuerystringParameter(str, str2);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ String getBodyContents() {
        return super.getBodyContents();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ Map getBodyParams() {
        return super.getBodyParams();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ String getCharset() {
        return super.getCharset();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ Map getHeaders() {
        return super.getHeaders();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ Map getQueryStringParams() {
        return super.getQueryStringParams();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ String getSanitizedUrl() {
        return super.getSanitizedUrl();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ String getUrl() {
        return super.getUrl();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ Verb getVerb() {
        return super.getVerb();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ Response send() {
        return super.send();
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void setCharset(String str) {
        super.setCharset(str);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void setConnectTimeout(int i, TimeUnit timeUnit) {
        super.setConnectTimeout(i, timeUnit);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void setConnectionKeepAlive(boolean z) {
        super.setConnectionKeepAlive(z);
    }

    @Override // org.scribe.model.Request
    public /* bridge */ /* synthetic */ void setReadTimeout(int i, TimeUnit timeUnit) {
        super.setReadTimeout(i, timeUnit);
    }

    public OAuthRequest(Verb verb, String url) {
        super(verb, url);
        this.oauthParameters = new HashMap();
    }

    public void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(checkKey(key), value);
    }

    private String checkKey(String key) {
        if (key.startsWith("oauth_") || key.equals(OAuthConstants.SCOPE)) {
            return key;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s' or start with '%s'", OAuthConstants.SCOPE, "oauth_"));
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    @Override // org.scribe.model.Request
    public String toString() {
        return String.format("@OAuthRequest(%s, %s)", getVerb(), getUrl());
    }
}
