package org.scribe.model;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final String scope;
    private final SignatureType signatureType;

    public OAuthConfig(String key, String secret) {
        this(key, secret, null, null, null);
    }

    public OAuthConfig(String key, String secret, String callback, SignatureType type, String scope) {
        this.apiKey = key;
        this.apiSecret = secret;
        this.callback = callback == null ? OAuthConstants.OUT_OF_BAND : callback;
        this.signatureType = type == null ? SignatureType.Header : type;
        this.scope = scope;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }
}
