package org.scribe.extractors;

import java.util.HashMap;
import java.util.Map;
import org.scribe.exceptions.OAuthParametersMissingException;
import org.scribe.model.OAuthRequest;
import org.scribe.utils.MapUtils;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/3.dex */
public class BaseStringExtractorImpl implements BaseStringExtractor {
    private static final String AMPERSAND_SEPARATED_STRING = "%s&%s&%s";

    @Override // org.scribe.extractors.BaseStringExtractor
    public String extract(OAuthRequest request) {
        checkPreconditions(request);
        String verb = URLUtils.percentEncode(request.getVerb().name());
        String url = URLUtils.percentEncode(request.getSanitizedUrl());
        String params = getSortedAndEncodedParams(request);
        return String.format(AMPERSAND_SEPARATED_STRING, verb, url, params);
    }

    private String getSortedAndEncodedParams(OAuthRequest request) {
        Map<String, String> params = new HashMap<>();
        MapUtils.decodeAndAppendEntries(request.getQueryStringParams(), params);
        MapUtils.decodeAndAppendEntries(request.getBodyParams(), params);
        MapUtils.decodeAndAppendEntries(request.getOauthParameters(), params);
        return URLUtils.percentEncode(MapUtils.concatSortedPercentEncodedParams(MapUtils.sort(params)));
    }

    private void checkPreconditions(OAuthRequest request) {
        Preconditions.checkNotNull(request, "Cannot extract base string from null object");
        if (request.getOauthParameters() == null || request.getOauthParameters().size() <= 0) {
            throw new OAuthParametersMissingException(request);
        }
    }
}
