package org.scribe.builder.api;

import org.scribe.model.Token;
import org.scribe.model.Verb;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class EvernoteApi extends DefaultApi10a {
    private static final String AUTHORIZATION_URL = "https://www.evernote.com/OAuth.action?oauth_token=%s";

    @Override // org.scribe.builder.api.DefaultApi10a
    public Verb getRequestTokenVerb() {
        return Verb.GET;
    }

    @Override // org.scribe.builder.api.DefaultApi10a
    public String getRequestTokenEndpoint() {
        return "https://www.evernote.com/oauth";
    }

    @Override // org.scribe.builder.api.DefaultApi10a
    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    @Override // org.scribe.builder.api.DefaultApi10a
    public String getAccessTokenEndpoint() {
        return "https://www.evernote.com/oauth";
    }

    @Override // org.scribe.builder.api.DefaultApi10a
    public String getAuthorizationUrl(Token requestToken) {
        return String.format(AUTHORIZATION_URL, requestToken.getToken());
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public static class Sandbox extends EvernoteApi {
        private static final String SANDBOX_URL = "https://sandbox.evernote.com/oauth";

        @Override // org.scribe.builder.api.EvernoteApi, org.scribe.builder.api.DefaultApi10a
        public String getRequestTokenEndpoint() {
            return SANDBOX_URL;
        }

        @Override // org.scribe.builder.api.EvernoteApi, org.scribe.builder.api.DefaultApi10a
        public String getAccessTokenEndpoint() {
            return SANDBOX_URL;
        }

        @Override // org.scribe.builder.api.EvernoteApi, org.scribe.builder.api.DefaultApi10a
        public String getAuthorizationUrl(Token requestToken) {
            return String.format("https://sandbox.evernote.com/oauth?oauth_token=%s", requestToken.getToken());
        }
    }
}
