package com.urbanairship.util;

import android.content.SharedPreferences;
import com.urbanairship.Logger;
import com.urbanairship.UAirship;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class NotificationIDGenerator {
    private static final int MAX_RANGE = 50;
    private static final String NEXT_ID_KEY = "count";
    private static final String SHARED_PREFERENCES_FILE = "com.urbanairship.notificationidgenerator";
    private static int start = 1000;
    private static int range = 40;

    private static int getInt(String str, int i) {
        return getPreferences().getInt(str, i);
    }

    private static SharedPreferences getPreferences() {
        return UAirship.shared().getApplicationContext().getSharedPreferences(SHARED_PREFERENCES_FILE, 0);
    }

    public static int getRange() {
        return range;
    }

    public static int getStart() {
        return start;
    }

    public static int nextID() {
        int i = getInt(NEXT_ID_KEY, start) + 1;
        if (i < start + range) {
            Logger.verbose("Incrementing notification id count");
            putInt(NEXT_ID_KEY, i);
        } else {
            Logger.verbose("Resetting notification id count");
            putInt(NEXT_ID_KEY, start);
        }
        Logger.verbose("Notification id: " + i);
        return i;
    }

    private static void putInt(String str, int i) {
        SharedPreferences.Editor edit = getPreferences().edit();
        edit.putInt(str, i);
        edit.commit();
    }

    public static void setRange(int i) {
        if (i > MAX_RANGE) {
            Logger.error("The maximum numer of notifications allowed is 50. Limiting alert id range to conform.");
            i = MAX_RANGE;
        }
        putInt(NEXT_ID_KEY, start);
        range = i;
    }

    public static void setStart(int i) {
        putInt(NEXT_ID_KEY, i);
        start = i;
    }
}
