package com.urbanairship.location;

import com.urbanairship.Preferences;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class LocationPreferences extends Preferences {
    static final String BACKGROUND_LOCATION_ENABLED_KEY = "com.urbanairship.location.BACKGROUND_LOCATION_ENABLED";
    static final String LOCATION_ENABLED_KEY = "com.urbanairship.location.LOCATION_ENABLED";

    public LocationPreferences() {
        super("com.urbanairship.location");
    }

    public boolean isBackgroundLocationEnabled() {
        return getBoolean(BACKGROUND_LOCATION_ENABLED_KEY, false);
    }

    public boolean isLocationEnabled() {
        return getBoolean(LOCATION_ENABLED_KEY, false);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean setBackgroundLocationEnabled(boolean z) {
        if (isBackgroundLocationEnabled() != z) {
            return putBoolean(BACKGROUND_LOCATION_ENABLED_KEY, z);
        }
        return true;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public boolean setLocationEnabled(boolean z) {
        if (isLocationEnabled() != z) {
            return putBoolean(LOCATION_ENABLED_KEY, z);
        }
        return true;
    }
}
