package com.urbanairship.iap.marketinterface;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Handler;
import com.urbanairship.Logger;
import com.urbanairship.iap.marketinterface.BillingService;
import com.urbanairship.iap.marketinterface.Consts;
import java.lang.reflect.Method;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public abstract class AbstractMarketListener {
    private static final Class<?>[] START_INTENT_SENDER_SIG = {IntentSender.class, Intent.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private final Handler mHandler;
    private Method mStartIntentSender;
    private Object[] mStartIntentSenderArgs = new Object[5];

    public AbstractMarketListener(Handler handler) {
        this.mHandler = handler;
    }

    private void initCompatibilityLayer(Activity activity) {
        try {
            this.mStartIntentSender = activity.getClass().getMethod("startIntentSender", START_INTENT_SENDER_SIG);
        } catch (NoSuchMethodException e) {
            this.mStartIntentSender = null;
        } catch (SecurityException e2) {
            this.mStartIntentSender = null;
        }
    }

    public abstract void onBillingSupported(boolean z);

    public abstract void onPurchaseStateChange(Consts.PurchaseState purchaseState, String str, int i, long j, String str2);

    public abstract void onRequestPurchaseResponse(BillingService.RequestPurchase requestPurchase, Consts.ResponseCode responseCode);

    public abstract void onRestoreTransactionsResponse(BillingService.RestoreTransactions restoreTransactions, Consts.ResponseCode responseCode);

    public void postPurchaseStateChange(final Consts.PurchaseState purchaseState, final String str, final int i, final long j, final String str2) {
        this.mHandler.post(new Runnable() { // from class: com.urbanairship.iap.marketinterface.AbstractMarketListener.1
            @Override // java.lang.Runnable
            public void run() {
                AbstractMarketListener.this.onPurchaseStateChange(purchaseState, str, i, j, str2);
            }
        });
    }

    public void startBuyPageActivity(Activity activity, PendingIntent pendingIntent, Intent intent) {
        initCompatibilityLayer(activity);
        if (this.mStartIntentSender == null) {
            try {
                pendingIntent.send(activity, 0, intent);
                return;
            } catch (PendingIntent.CanceledException e) {
                Logger.error("error starting buy page activity", e);
                return;
            }
        }
        try {
            this.mStartIntentSenderArgs[0] = pendingIntent.getIntentSender();
            this.mStartIntentSenderArgs[1] = intent;
            this.mStartIntentSenderArgs[2] = 0;
            this.mStartIntentSenderArgs[3] = 0;
            this.mStartIntentSenderArgs[4] = 0;
            this.mStartIntentSender.invoke(activity, this.mStartIntentSenderArgs);
        } catch (Exception e2) {
            Logger.error("error starting buy page activity", e2);
        }
    }
}
