package com.urbanairship.iap;

import com.urbanairship.Logger;
import com.urbanairship.util.Toaster;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class DefaultIAPEventListener extends IAPEventListener {
    @Override // com.urbanairship.iap.IAPEventListener
    public void billingSupported(boolean z) {
        if (z) {
            return;
        }
        Toaster.longerToast("Billing is not supported on this version of Android Market");
    }

    @Override // com.urbanairship.iap.IAPEventListener
    public void downloadFailed(Product product) {
        Toaster.simpleToast(String.format("Download of %s failed", product.getTitle()));
    }

    @Override // com.urbanairship.iap.IAPEventListener
    public void downloadProgress(Product product, int i) {
        Logger.verbose("Download progress for " + product.getTitle() + ": " + i + "%");
    }

    @Override // com.urbanairship.iap.IAPEventListener
    public void downloadStarted(Product product, int i) {
        if (i == 1) {
            Toaster.simpleToast(String.format("Downloading %s...", product.getTitle()));
        }
    }

    @Override // com.urbanairship.iap.IAPEventListener
    public void downloadSuccessful(Product product) {
        Toaster.simpleToast(product.getTitle() + " was sucessfully installed");
    }

    @Override // com.urbanairship.iap.IAPEventListener
    public void marketUnavailable(Product product) {
        Toaster.longerToast("Error connecting to billing service, please try again later");
    }

    @Override // com.urbanairship.iap.IAPEventListener
    public void restoreStarted() {
        Toaster.simpleToast("Checking for existing purchases");
    }
}
