package com.urbanairship.analytics;

import android.location.Location;
import com.urbanairship.Logger;
import com.urbanairship.UAirship;
import com.urbanairship.analytics.EventDataManager;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class LocationEvent extends Event {
    private static final String TYPE = "location";
    private String accuracy;
    private String foreground;
    private String latitude;
    private String longitude;
    private String provider;
    private String requestedAccuracy;
    private String updateDistance;
    private UpdateType updateType;

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public enum AllowableProvider {
        GPS,
        NETWORK,
        PASSIVE,
        UNKNOWN
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    public enum UpdateType {
        CONTINUOUS,
        SINGLE,
        CHANGE
    }

    public LocationEvent(Location location, UpdateType updateType, int i, int i2) {
        this.latitude = String.valueOf(location.getLatitude());
        this.longitude = String.valueOf(location.getLongitude());
        this.provider = getValidProviderName(location.getProvider());
        this.accuracy = String.valueOf(location.getAccuracy());
        this.requestedAccuracy = i >= 0 ? String.valueOf(i) : "NONE";
        this.updateDistance = i2 >= 0 ? String.valueOf(i2) : "NONE";
        this.foreground = UAirship.shared().getAnalytics().isAppInForeground() ? "true" : "false";
        this.updateType = updateType;
        Logger.info(String.format("New location at lat: %s, long: %s found with provider: %s", this.latitude, this.longitude, this.provider));
    }

    private String getValidProviderName(String str) {
        for (AllowableProvider allowableProvider : AllowableProvider.values()) {
            if (allowableProvider.toString().equalsIgnoreCase(str)) {
                return str.toUpperCase();
            }
        }
        return AllowableProvider.UNKNOWN.toString();
    }

    @Override // com.urbanairship.analytics.Event
    JSONObject getData() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(EventDataManager.Events.COLUMN_NAME_SESSION_ID, getEnvironment().getSessionId());
            jSONObject.put("lat", this.latitude);
            jSONObject.put("long", this.longitude);
            jSONObject.put("requested_accuracy", this.requestedAccuracy);
            jSONObject.put("update_type", this.updateType.toString());
            jSONObject.put("provider", this.provider);
            jSONObject.put("h_accuracy", this.accuracy);
            jSONObject.put("v_accuracy", "NONE");
            jSONObject.put("foreground", this.foreground);
            jSONObject.put("update_dist", this.updateDistance);
        } catch (JSONException e) {
            Logger.error("Error constructing JSON data for " + getType());
        }
        return jSONObject;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.urbanairship.analytics.Event
    public String getType() {
        return TYPE;
    }
}
