package com.urbanairship.analytics;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.tapjoy.TapjoyConstants;
import com.urbanairship.Logger;
import com.urbanairship.UAirship;
import com.urbanairship.analytics.ActivityMonitor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class Analytics {
    public static final String ACTION_ANALYTICS_START = "com.urbanairship.analytics.START";
    public static final String ACTION_APP_BACKGROUND = "com.urbanairship.analytics.APP_BACKGROUND";
    public static final String ACTION_APP_FOREGROUND = "com.urbanairship.analytics.APP_FOREGROUND";
    private String conversionPushId;
    private BroadcastReceiver appStateChangeReceiver = new BroadcastReceiver() { // from class: com.urbanairship.analytics.Analytics.3
        @Override // android.content.BroadcastReceiver
        public void onReceive(Context context, Intent intent) {
            Logger.verbose(intent.getAction());
            if (Analytics.ACTION_APP_BACKGROUND.equals(intent.getAction())) {
                Analytics.this.inBackground = true;
            } else if (Analytics.ACTION_APP_FOREGROUND.equals(intent.getAction())) {
                Analytics.this.inBackground = false;
            }
        }
    };
    private final String server = UAirship.shared().getAirshipConfigOptions().analyticsServer;
    private Session session = new Session();
    private boolean inBackground = true;
    private ActivityMonitor activityMonitor = new ActivityMonitor(new ActivityMonitor.Delegate() { // from class: com.urbanairship.analytics.Analytics.1
        @Override // com.urbanairship.analytics.ActivityMonitor.Delegate
        public void onBackground() {
            Analytics.this.inBackground = true;
            Analytics.this.addEvent(new AppBackgroundEvent());
            Analytics.this.sendBackgroundBroadcast();
            Analytics.this.conversionPushId = null;
        }

        @Override // com.urbanairship.analytics.ActivityMonitor.Delegate
        public void onForeground() {
            Analytics.this.session = new Session();
            Analytics.this.inBackground = false;
            Analytics.this.sendForegroundBroadcast();
            Analytics.this.addEvent(new AppForegroundEvent());
        }
    });
    private EventDataManager dataManager = new EventDataManager();
    private EventUploadManager uploadManager = new EventUploadManager(this.dataManager);

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    class AddEventTask extends AsyncTask<Event, Void, Void> {
        AddEventTask() {
        }

        /* JADX INFO: Access modifiers changed from: protected */
        /* JADX WARN: Code restructure failed: missing block: B:29:0x00d8, code lost:
            com.urbanairship.Logger.info("LocationEvent was inserted, but may not be updated until " + (r7 - r5) + " ms have passed");
         */
        @Override // android.os.AsyncTask
        /*
            Code decompiled incorrectly, please refer to instructions dump.
            To view partially-correct code enable 'Show inconsistent code' option in preferences
        */
        public java.lang.Void doInBackground(com.urbanairship.analytics.Event... r13) {
            /*
                Method dump skipped, instructions count: 285
                To view this dump change 'Code comments level' option to 'DEBUG'
            */
            throw new UnsupportedOperationException("Method not decompiled: com.urbanairship.analytics.Analytics.AddEventTask.doInBackground(com.urbanairship.analytics.Event[]):java.lang.Void");
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
    class Session {
        private String id = UUID.randomUUID().toString();

        public Session() {
            Logger.verbose("New session: " + this.id);
        }

        public String getId() {
            return this.id;
        }

        public void log() {
            Logger.verbose("Analytics Session - id: " + this.id);
        }
    }

    public Analytics() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_APP_BACKGROUND);
        intentFilter.addAction(ACTION_APP_FOREGROUND);
        UAirship.shared().getApplicationContext().registerReceiver(this.appStateChangeReceiver, intentFilter);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static String getHashedDeviceId() {
        String string = Settings.Secure.getString(UAirship.shared().getApplicationContext().getContentResolver(), TapjoyConstants.TJC_ANDROID_ID);
        if (string == null) {
            return "unavailable";
        }
        byte[] bytes = string.getBytes();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(bytes, 0, bytes.length);
            byte[] digest = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            int length = digest.length;
            for (int i = 0; i < length; i++) {
                sb.append(String.format("%02x", Byte.valueOf(digest[i])));
            }
            return sb.toString();
        } catch (NoSuchAlgorithmException e) {
            Logger.error("Unable to hash the device ID: SHA1 digester not present");
            return "unavailable";
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void sendBackgroundBroadcast() {
        UAirship.shared().getApplicationContext().sendStickyBroadcast(new Intent(ACTION_APP_BACKGROUND));
    }

    /* JADX INFO: Access modifiers changed from: private */
    public void sendForegroundBroadcast() {
        UAirship.shared().getApplicationContext().sendStickyBroadcast(new Intent(ACTION_APP_FOREGROUND));
    }

    public void activityStarted(Activity activity) {
        this.activityMonitor.addActivity(activity);
        addEvent(new ActivityStartedEvent(activity));
    }

    public void activityStopped(Activity activity) {
        addEvent(new ActivityStoppedEvent(activity));
        this.activityMonitor.removeActivity(activity);
    }

    public void addEvent(final Event event) {
        String str = UAirship.shared().getAirshipConfigOptions().analyticsServer;
        if (str == null || str.length() == 0 || !UAirship.shared().getAirshipConfigOptions().analyticsEnabled) {
            return;
        }
        event.log();
        new Handler(Looper.getMainLooper()).post(new Runnable() { // from class: com.urbanairship.analytics.Analytics.2
            @Override // java.lang.Runnable
            public void run() {
                new AddEventTask().execute(event);
            }
        });
    }

    public String getConversionPushId() {
        return this.conversionPushId;
    }

    String getServer() {
        return this.server;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public Session getSession() {
        return this.session;
    }

    public boolean isAppInForeground() {
        return !this.inBackground;
    }

    public void setConversionPushId(String str) {
        this.conversionPushId = str;
    }

    public void startUploadingIfNecessary() {
        this.uploadManager.startUploadingIfNecessary();
    }
}
