package com.urbanairship.analytics;

import android.app.Activity;
import com.urbanairship.Logger;
import com.urbanairship.analytics.Event;
import com.urbanairship.analytics.EventDataManager;
import org.json.JSONException;
import org.json.JSONObject;

/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public class ActivityStartedEvent extends Event {
    static final String TYPE = "activity_started";
    private String className;

    /* JADX INFO: Access modifiers changed from: package-private */
    public ActivityStartedEvent(Activity activity) {
        this.className = activity.getComponentName().getClassName();
    }

    @Override // com.urbanairship.analytics.Event
    JSONObject getData() {
        JSONObject jSONObject = new JSONObject();
        Event.Environment environment = getEnvironment();
        try {
            jSONObject.put("class_name", this.className);
            jSONObject.put(EventDataManager.Events.COLUMN_NAME_SESSION_ID, environment.getSessionId());
        } catch (JSONException e) {
            Logger.error("Error constructing JSON data for " + getType());
        }
        return jSONObject;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.urbanairship.analytics.Event
    public String getType() {
        return TYPE;
    }
}
