package com.urbanairship;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Properties;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/2.dex */
public abstract class Options {
    public abstract String getDefaultPropertiesFilename();

    public abstract boolean isValid();

    public void loadFromProperties(Context context) {
        loadFromProperties(context, getDefaultPropertiesFilename());
    }

    public void loadFromProperties(Context context, String str) {
        String property;
        AssetManager assets = context.getResources().getAssets();
        try {
            if (!Arrays.asList(assets.list("")).contains(str)) {
                Logger.verbose("Options - Couldn't find " + str);
                return;
            }
            Properties properties = new Properties();
            try {
                properties.load(assets.open(str));
                ListIterator listIterator = Arrays.asList(getClass().getDeclaredFields()).listIterator();
                while (listIterator.hasNext()) {
                    Field field = (Field) listIterator.next();
                    if (!Options.class.isAssignableFrom(field.getType()) && (property = properties.getProperty(field.getName())) != null) {
                        try {
                            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                                field.set(this, Boolean.valueOf(property));
                            } else if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                                field.set(this, Integer.valueOf(property));
                            } else if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                                field.set(this, Long.valueOf(property));
                            } else {
                                try {
                                    field.set(this, property.trim());
                                } catch (IllegalArgumentException e) {
                                    Logger.error("Unable to set field '" + field.getName() + "' due to type mismatch.");
                                }
                            }
                        } catch (IllegalAccessException e2) {
                            Logger.error("Unable to set field '" + field.getName() + "' because the field is not visible.");
                        }
                    }
                }
            } catch (IOException e3) {
                Logger.error("Error loading properties file " + str, e3);
            }
        } catch (IOException e4) {
            Logger.error(e4);
        }
    }
}
